-- phpMyAdmin SQL Dump
-- version 2.11.4
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Apr 06, 2008 at 05:56 PM
-- Server version: 5.0.51
-- PHP Version: 5.2.5

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Database: `backendpro`
--

-- --------------------------------------------------------

--
-- Table structure for table `be_acl_actions`
--

DROP TABLE IF EXISTS `be_acl_actions`;
CREATE TABLE IF NOT EXISTS `be_acl_actions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(254) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_acl_actions`
--


-- --------------------------------------------------------

--
-- Table structure for table `be_acl_groups`
--

DROP TABLE IF EXISTS `be_acl_groups`;
CREATE TABLE IF NOT EXISTS `be_acl_groups` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `lft` int(10) unsigned NOT NULL default '0',
  `rgt` int(10) unsigned NOT NULL default '0',
  `name` varchar(254) NOT NULL,
  `link` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `lft` (`lft`),
  KEY `rgt` (`rgt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_acl_groups`
--

INSERT INTO `be_acl_groups` (`id`, `lft`, `rgt`, `name`, `link`) VALUES
(1, 1, 6, 'Member', NULL),
(2, 2, 3, 'Administrator', NULL),
(3, 4, 5, 'Programming', 0);

-- --------------------------------------------------------

--
-- Table structure for table `be_acl_permissions`
--

DROP TABLE IF EXISTS `be_acl_permissions`;
CREATE TABLE IF NOT EXISTS `be_acl_permissions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `aro_id` int(10) unsigned NOT NULL default '0',
  `aco_id` int(10) unsigned NOT NULL default '0',
  `allow` char(1) default NULL,
  PRIMARY KEY  (`id`),
  KEY `aro_id` (`aro_id`),
  KEY `aco_id` (`aco_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_acl_permissions`
--

INSERT INTO `be_acl_permissions` (`id`, `aro_id`, `aco_id`, `allow`) VALUES
(1, 2, 1, 'Y'),
(3, 3, 1, 'Y'),
(4, 1, 1, 'N'),
(5, 3, 2, 'N'),
(6, 2, 15, 'N');

-- --------------------------------------------------------

--
-- Table structure for table `be_acl_permission_actions`
--

DROP TABLE IF EXISTS `be_acl_permission_actions`;
CREATE TABLE IF NOT EXISTS `be_acl_permission_actions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `access_id` int(10) unsigned NOT NULL default '0',
  `axo_id` int(10) unsigned NOT NULL default '0',
  `allow` char(1) default NULL,
  PRIMARY KEY  (`id`),
  KEY `access_id` (`access_id`),
  KEY `axo_id` (`axo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_acl_permission_actions`
--


-- --------------------------------------------------------

--
-- Table structure for table `be_acl_resources`
--

DROP TABLE IF EXISTS `be_acl_resources`;
CREATE TABLE IF NOT EXISTS `be_acl_resources` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `lft` int(10) unsigned NOT NULL default '0',
  `rgt` int(10) unsigned NOT NULL default '0',
  `name` varchar(254) NOT NULL,
  `link` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `lft` (`lft`),
  KEY `rgt` (`rgt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_acl_resources`
--

INSERT INTO `be_acl_resources` (`id`, `lft`, `rgt`, `name`, `link`) VALUES
(1, 1, 34, 'Site', NULL),
(2, 14, 33, 'Control Panel', NULL),
(3, 15, 32, 'System', NULL),
(4, 26, 27, 'Members', NULL),
(5, 16, 25, 'Access Control', NULL),
(6, 28, 29, 'Settings', NULL),
(7, 30, 31, 'Utilities', NULL),
(8, 23, 24, 'Permissions', NULL),
(9, 21, 22, 'Groups', NULL),
(10, 19, 20, 'Resources', NULL),
(11, 17, 18, 'Actions', NULL),
(15, 2, 13, 'ConCentric', 0),
(16, 3, 12, 'Programming Menu', 0),
(17, 10, 11, 'Programming Settings', 0),
(19, 8, 9, 'Programming Data Entry', 0),
(25, 6, 7, 'Programming Reports', 0),
(26, 4, 5, 'Programming Tools', 0);

-- --------------------------------------------------------

--
-- Table structure for table `be_groups`
--

DROP TABLE IF EXISTS `be_groups`;
CREATE TABLE IF NOT EXISTS `be_groups` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `locked` tinyint(1) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_groups`
--

INSERT INTO `be_groups` (`id`, `locked`, `disabled`) VALUES
(1, 1, 0),
(2, 1, 0),
(3, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `be_preferences`
--

DROP TABLE IF EXISTS `be_preferences`;
CREATE TABLE IF NOT EXISTS `be_preferences` (
  `name` varchar(254) character set latin1 NOT NULL,
  `value` text character set latin1 NOT NULL,
  `value_array` text CHARACTER SET latin1 COLLATE latin1_spanish_ci NOT NULL,
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_preferences`
--

INSERT INTO `be_preferences` (`name`, `value`, `value_array`) VALUES
('default_user_group', '1', ''),
('smtp_host', '', ''),
('keep_error_logs_for', '30', ''),
('email_protocol', 'sendmail', ''),
('use_registration_captcha', '0', ''),
('maintenance_message', 'I am currently making enhancements to the site. I appreciate your patience during this time, and encourage you to return here shortly.', ''),
('page_debug', '0', ''),
('webmaster_email', '', ''),
('webmaster_name', 'Webmaster', ''),
('automated_from_name', 'ConCentric', ''),
('allow_user_registration', '0', ''),
('use_login_captcha', '0', ''),
('maintenance_mode', '0', ''),
('site_name', 'ConCentric', ''),
('automated_from_email', '', ''),
('account_activation_time', '7', ''),
('allow_user_profiles', '0', ''),
('activation_method', 'admin', ''),
('autologin_period', '30', ''),
('min_password_length', '8', ''),
('smtp_user', '', ''),
('smtp_pass', '', ''),
('email_mailpath', '/usr/sbin/sendmail', ''),
('smtp_port', '25', ''),
('smtp_timeout', '5', ''),
('email_wordwrap', '1', ''),
('email_wrapchars', '76', ''),
('email_mailtype', 'text', ''),
('email_charset', 'utf-8', ''),
('bcc_batch_mode', '0', ''),
('bcc_batch_size', '200', '');

-- --------------------------------------------------------

--
-- Table structure for table `be_resources`
--

DROP TABLE IF EXISTS `be_resources`;
CREATE TABLE IF NOT EXISTS `be_resources` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `locked` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_resources`
--

INSERT INTO `be_resources` (`id`, `locked`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(15, 0),
(16, 0),
(17, 0),
(19, 0),
(25, 0),
(26, 0);

-- --------------------------------------------------------

--
-- Table structure for table `be_users`
--

DROP TABLE IF EXISTS `be_users`;
CREATE TABLE IF NOT EXISTS `be_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `username` varchar(32) NOT NULL,
  `password` varchar(40) NOT NULL,
  `email` varchar(254) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL default '0',
  `group` int(10) unsigned default NULL,
  `activation_key` varchar(32) default NULL,
  `last_visit` datetime default NULL,
  `created` datetime NOT NULL,
  `modified` datetime default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `password` (`password`),
  KEY `group` (`group`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_users`
--
 
-- --------------------------------------------------------

--
-- Table structure for table `be_user_profiles`
--

DROP TABLE IF EXISTS `be_user_profiles`;
CREATE TABLE IF NOT EXISTS `be_user_profiles` (
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `be_user_profiles`
--

-- --------------------------------------------------------

--
-- Table structure for table `cc_categories`
--

DROP TABLE IF EXISTS `cc_categories`;
CREATE TABLE IF NOT EXISTS `cc_categories` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_categories`
--

INSERT INTO `cc_categories` (`id`, `name`) VALUES
(1, 'Panel-Event'),
(2, 'Game'),
(3, 'Film'),
(4, 'Anime');

-- --------------------------------------------------------

--
-- Table structure for table `cc_colors`
--

DROP TABLE IF EXISTS `cc_colors`;
CREATE TABLE IF NOT EXISTS `cc_colors` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `htmlCode` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_colors`
--

INSERT INTO `cc_colors` (`id`, `name`, `htmlCode`) VALUES
(1, 'aliceblue', 'F0F8FF'),
(2, 'antiquewhite', 'FAEBD7'),
(3, 'aqua', '00FFFF'),
(4, 'aquamarine', '7FFFD4'),
(5, 'azure', 'F0FFFF'),
(6, 'beige', 'F5F5DC'),
(7, 'bisque', 'FFE4C4'),
(8, 'black', '000000'),
(9, 'blanchedalmond', 'FFEBCD'),
(10, 'blue', '0000FF'),
(11, 'blueviolet', '8A2BE2'),
(12, 'brown', 'A52A2A'),
(13, 'burlywood', 'DEB887'),
(14, 'cadetblue', '5F9EA0'),
(15, 'chartreuse', '7FFF00'),
(16, 'chocolate', 'D2691E'),
(17, 'coral', 'FF7F50'),
(18, 'cornflowerblue', '6495ED'),
(19, 'cornsilk', 'FFF8DC'),
(20, 'crimson', 'DC143C'),
(21, 'cyan', '00FFFF'),
(22, 'darkblue', '00008B'),
(23, 'darkcyan', '008B8B'),
(24, 'darkgoldenrod', 'B8860B'),
(25, 'darkgray', 'A9A9A9'),
(26, 'darkgreen', '006400'),
(27, 'darkkhaki', 'BDB76B'),
(28, 'darkmagenta', '8B008B'),
(29, 'darkolivegreen', '556B2F'),
(30, 'darkorange', 'FF8C00'),
(31, 'darkorchid', '9932CC'),
(32, 'darkred', '8B0000'),
(33, 'darksalmon', 'E9967A'),
(34, 'darkseagreen', '8FBC8F'),
(35, 'darkslateblue', '483D8B'),
(36, 'darkslategray', '2F4F4F'),
(37, 'darkturquoise', '00CED1'),
(38, 'darkviolet', '9400D3'),
(39, 'deeppink', 'FF1493'),
(40, 'deepskyblue', '00BFFF'),
(41, 'dimgray', '696969'),
(42, 'dodgerblue', '1E90FF'),
(43, 'firebrick', 'B22222'),
(44, 'floralwhite', 'FFFAF0'),
(45, 'forestgreen', '228B22'),
(46, 'fuchsia', 'FF00FF'),
(47, 'gainsboro', 'DCDCDC'),
(48, 'ghostwhite', 'F8F8FF'),
(49, 'gold', 'FFD700'),
(50, 'goldenrod', 'DAA520'),
(51, 'gray', '808080'),
(52, 'green', '008000'),
(53, 'greenyellow', 'ADFF2F'),
(54, 'honeydew', 'F0FFF0'),
(55, 'hotpink', 'FF69B4'),
(56, 'indianred', 'CD5C5C'),
(57, 'indigo', '4B0082'),
(58, 'ivory', 'FFFFF0'),
(59, 'khaki', 'F0E68C'),
(60, 'lavender', 'E6E6FA'),
(61, 'lavenderblush', 'FFF0F5'),
(62, 'lawngreen', '7CFC00'),
(63, 'lemonchiffon', 'FFFACD'),
(64, 'lightblue', 'ADD8E6'),
(65, 'lightcoral', 'F08080'),
(66, 'lightcyan', 'E0FFFF'),
(67, 'lightgoldenrodyellow', 'FAFAD2'),
(68, 'lightgreen', '90EE90'),
(69, 'lightgrey', 'D3D3D3'),
(70, 'lightpink', 'FFB6C1'),
(71, 'lightsalmon', 'FFA07A'),
(72, 'lightseagreen', '20B2AA'),
(73, 'lightskyblue', '87CEFA'),
(74, 'lightslategray', '778899'),
(75, 'lightsteelblue', 'B0C4DE'),
(76, 'lightyellow', 'FFFFE0'),
(77, 'lime', '00FF00'),
(78, 'limegreen', '32CD32'),
(79, 'linen', 'FAF0E6'),
(80, 'magenta', 'FF00FF'),
(81, 'maroon', '800000'),
(82, 'mediumaquamarine', '66CDAA'),
(83, 'mediumblue', '0000CD'),
(84, 'mediumorchid', 'BA55D3'),
(85, 'mediumpurple', '9370DB'),
(86, 'mediumseagreen', '3CB371'),
(87, 'mediumslateblue', '7B68EE'),
(88, 'mediumspringgreen', '00FA9A'),
(89, 'mediumturquoise', '48D1CC'),
(90, 'mediumvioletred', 'C71585'),
(91, 'midnightblue', '191970'),
(92, 'mintcream', 'F5FFFA'),
(93, 'mistyrose', 'FFE4E1'),
(94, 'moccasin', 'FFE4B5'),
(95, 'navajowhite', 'FFDEAD'),
(96, 'navy', '000080'),
(97, 'oldlace', 'FDF5E6'),
(98, 'olive', '808000'),
(99, 'olivedrab', '6B8E23'),
(100, 'orange', 'FFA500'),
(101, 'orangered', 'FF4500'),
(102, 'orchid', 'DA70D6'),
(103, 'palegoldenrod', 'EEE8AA'),
(104, 'palegreen', '98FB98'),
(105, 'paleturquoise', 'AFEEEE'),
(106, 'palevioletred', 'DB7093'),
(107, 'papayawhip', 'FFEFD5'),
(108, 'peachpuff', 'FFDAB9'),
(109, 'peru', 'CD853F'),
(110, 'pink', 'FFC0CB'),
(111, 'plum', 'DDA0DD'),
(112, 'powderblue', 'B0E0E6'),
(113, 'purple', '800080'),
(114, 'red', 'FF0000'),
(115, 'rosybrown', 'BC8F8F'),
(116, 'royalblue', '4169E1'),
(117, 'saddlebrown', '8B4513'),
(118, 'salmon', 'FA8072'),
(119, 'sandybrown', 'F4A460'),
(120, 'seagreen', '2E8B57'),
(121, 'seashell', 'FFF5EE'),
(122, 'sienna', 'A0522D'),
(123, 'silver', 'C0C0C0'),
(124, 'skyblue', '87CEEB'),
(125, 'slateblue', '6A5ACD'),
(126, 'slategray', '708090'),
(127, 'snow', 'FFFAFA'),
(128, 'springgreen', '00FF7F'),
(129, 'steelblue', '4682B4'),
(130, 'tan', 'D2B48C'),
(131, 'teal', '008080'),
(132, 'thistle', 'D8BFD8'),
(133, 'tomato', 'FD6347'),
(134, 'turquoise', '40E0D0'),
(135, 'violet', 'EE82EE'),
(136, 'wheat', 'F5DEB3'),
(137, 'white', 'FFFFFF'),
(138, 'whitesmoke', 'F5F5F5'),
(139, 'yellow', 'FFFF00'),
(140, 'yellowgreen', '9ACD32');

-- --------------------------------------------------------

--
-- Table structure for table `cc_eventParticipants`
--

DROP TABLE IF EXISTS `cc_eventParticipants`;
CREATE TABLE IF NOT EXISTS `cc_eventParticipants` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `eventID` smallint(5) NOT NULL,
  `participantID` smallint(5) NOT NULL,
  `moderatorQ` tinyint(1) NOT NULL DEFAULT '0',
  `requiredQ` tinyint(1) NOT NULL DEFAULT '0',
  `confirmedQ` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `eventID` (`eventID`),
  KEY `participantID` (`participantID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_eventParticipants`
--

-- --------------------------------------------------------

--
-- Table structure for table `cc_eventLocations`
--

DROP TABLE IF EXISTS `cc_eventLocations`;
CREATE TABLE IF NOT EXISTS `cc_eventLocations` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `eventID` smallint(5) NOT NULL,
  `locationID` smallint(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `eventID` (`eventID`),
  KEY `locationID` (`locationID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_eventLocations`
--

-- --------------------------------------------------------

--
-- Table structure for table `cc_events`
--

DROP TABLE IF EXISTS `cc_events`;
CREATE TABLE IF NOT EXISTS `cc_events` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `startDateTime` datetime NOT NULL,
  `description` text NOT NULL,
  `eventLength` float NOT NULL DEFAULT '0' COMMENT 'Time in hours and fractions thereof.',
  `setupTime` float NOT NULL DEFAULT '0' COMMENT 'Time in hours and fractions thereof.',
  `teardownTime` float NOT NULL DEFAULT '0' COMMENT 'Time in hours and fractions thereof.',
  `reimbursibleQ` tinyint(1) NOT NULL DEFAULT '1',
  `activeQ` tinyint(1) NOT NULL DEFAULT '1',
  `locationSetupID` smallint(5) NOT NULL,
  `categoryID` smallint(5) NOT NULL,
  `hideQ` tinyint(1) NOT NULL DEFAULT '0',
  `hostDescription` varchar(50) NOT NULL DEFAULT 'Panelists' COMMENT 'Description of person(s) hosting this event - Default is Panelists',
  `hidePanelistsQ` tinyint(1) NOT NULL DEFAULT '0',
  `trackID` smallint(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `locationSetupID` (`locationSetupID`),
  KEY `categoryID` (`categoryID`),
  KEY `startDateTime` (`startDateTime`),
  KEY `activeQ` (`activeQ`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_events`
--

-- --------------------------------------------------------

--
-- Table structure for table `cc_participants`
--

DROP TABLE IF EXISTS `cc_participants`;
CREATE TABLE IF NOT EXISTS `cc_participants` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `sortedName` varchar(255) NOT NULL,
  `address1` varchar(255) NOT NULL,
  `address2` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `postalCode` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phoneNumber` varchar(255) NOT NULL,
  `bio` varchar(255) NOT NULL,
  `notes` varchar(255) NOT NULL,
  `proGOHQ` tinyint(1) NOT NULL DEFAULT '0',
  `equipmentQ` tinyint(1) NOT NULL DEFAULT '0',
  `activeQ` tinyint(1) NOT NULL DEFAULT '1',
  `hideQ` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sortedName` (`sortedName`),
  KEY `equipmentQ` (`equipmentQ`),
  KEY `activeQ` (`activeQ`),
  KEY `hideQ` (`hideQ`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_participants`
--

-- --------------------------------------------------------

--
-- Table structure for table `cc_locations`
--

DROP TABLE IF EXISTS `cc_locations`;
CREATE TABLE IF NOT EXISTS `cc_locations` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `sortOrder` smallint(5) NOT NULL,
  `alternateName` varchar(255) NOT NULL,
  `capacity` varchar(255) NOT NULL,
  `colorID` smallint(5) NOT NULL,
  `publicQ` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sortOrder` (`sortOrder`),
  KEY `colorID` (`colorID`),
  KEY `publicQ` (`publicQ`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_locations`
--

-- --------------------------------------------------------

--
-- Table structure for table `cc_locationSetups`
--

DROP TABLE IF EXISTS `cc_locationSetups`;
CREATE TABLE IF NOT EXISTS `cc_locationSetups` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `description` text NOT NULL,
  `colorID` smallint(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `colorID` (`colorID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_locationSetups`
--

INSERT INTO `cc_locationSetups` (`id`, `name`, `description`, `colorID`) VALUES
(1, 'Theater', 'Theater setup consists of rows of chairs facing a table with 4 chairs.', 1);

-- --------------------------------------------------------

--
-- Table structure for table `cc_settings`
--

DROP TABLE IF EXISTS `cc_settings`;
CREATE TABLE IF NOT EXISTS `cc_settings` (
  `name` varchar(253) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `cc_settings`
--

INSERT INTO `cc_settings` (`name`, `value`) VALUES
('convention_name', ''),
('start_date_time', ''),
('end_date_time', ''),
('interval_length', ''),
('draft_mode_q', '1'),
('hours', '');

-- --------------------------------------------------------

--
-- Table structure for table `cc_tracks`
--

DROP TABLE IF EXISTS `cc_tracks`;
CREATE TABLE IF NOT EXISTS `cc_tracks` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET latin1 NOT NULL,
  `publicQ` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

--
-- Dumping data for table `cc_tracks`
--

INSERT INTO `cc_tracks` (`id`, `name`, `publicQ`) VALUES
(1, 'Other', 1),
(2, 'Adult', 1),
(3, 'Art', 1),
(4, 'Book', 1),
(5, 'Event', 1),
(6, 'Fandom', 1),
(7, 'Filk', 1),
(8, 'Games', 1),
(9, 'GOH', 1),
(10, 'Late Night', 1),
(11, 'Media', 1),
(12, 'Science', 1),
(13, 'Writing', 1),
(14, 'Young Fan', 1);

-- --------------------------------------------------------

--
-- Table structure for table `ci_sessions`
--

DROP TABLE IF EXISTS `ci_sessions`;
CREATE TABLE IF NOT EXISTS `ci_sessions` (
  `session_id` varchar(40) character set latin1 NOT NULL default '0',
  `ip_address` varchar(16) character set latin1 NOT NULL default '0',
  `user_agent` varchar(50) character set latin1 NOT NULL,
  `last_activity` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ci_sessions`

--
-- Constraints for dumped tables
--

--
-- Constraints for table `be_acl_permissions`
--
ALTER TABLE `be_acl_permissions`
  ADD CONSTRAINT `be_acl_permissions_ibfk_1` FOREIGN KEY (`aro_id`) REFERENCES `be_acl_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `be_acl_permissions_ibfk_2` FOREIGN KEY (`aco_id`) REFERENCES `be_acl_resources` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `be_acl_permission_actions`
--
ALTER TABLE `be_acl_permission_actions`
  ADD CONSTRAINT `be_acl_permission_actions_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `be_acl_permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `be_acl_permission_actions_ibfk_2` FOREIGN KEY (`axo_id`) REFERENCES `be_acl_actions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `be_groups`
--
ALTER TABLE `be_groups`
  ADD CONSTRAINT `be_groups_ibfk_1` FOREIGN KEY (`id`) REFERENCES `be_acl_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `be_resources`
--
ALTER TABLE `be_resources`
  ADD CONSTRAINT `be_resources_ibfk_1` FOREIGN KEY (`id`) REFERENCES `be_acl_resources` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `be_users`
--
ALTER TABLE `be_users`
  ADD CONSTRAINT `be_users_ibfk_1` FOREIGN KEY (`group`) REFERENCES `be_acl_groups` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `be_user_profiles`
--
ALTER TABLE `be_user_profiles`
  ADD CONSTRAINT `be_user_profiles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `be_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cc_eventParticipants`
--
ALTER TABLE `cc_eventParticipants`
  ADD CONSTRAINT `cc_eventParticipants_ibfk_1` FOREIGN KEY (`eventID`) REFERENCES `cc_events` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `cc_eventParticipants_ibfk_2` FOREIGN KEY (`participantID`) REFERENCES `cc_participants` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cc_eventLocations`
--
ALTER TABLE `cc_eventLocations`
  ADD CONSTRAINT `cc_eventLocations_ibfk_1` FOREIGN KEY (`eventID`) REFERENCES `cc_events` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `cc_eventLocations_ibfk_2` FOREIGN KEY (`locationID`) REFERENCES `cc_locations` (`id`) ON DELETE CASCADE;


SET FOREIGN_KEY_CHECKS=1;