<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : participants.php
 *
 * DESCRIPTION   : participants module controller
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:59 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		participants component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Participants extends Concentric_Controller
{
	/**
	* Contructor function
	*
	* Load the instance of CI by invoking the parent constructor
	*
	* @access      public
	* @return      none
	*/
	function Participants()
	{
		// Call parent constructor
		parent::Concentric_Controller();

		$this->form_name = "Participants";
		$this->load->model('participants_model');    // Instantiate the model
		// load helper library
		$this->load->helper('concentric');
	}

	// -------------------------------------------------------------------------
	/**
	* "Index" Page
	*
	* Default class action
	*
	* @access      public
	* @return      none
	*/
	function index($sortby = '')
	{
		// The default action is the browse action
		$this->browse($sortby);
	}

	// -------------------------------------------------------------------------
	// Function: browse()
	// Description: Extracts a list of all data records and
	//              displays it.
	function browse($sortby = '')
	{
		// get sort from cookie / save new sort to cookie
		$array = get_participants_sort($sortby);
		$sortname = $array['name'];
		$sortdirection = $array['direction'];
		$sortby = $array['sortby'];

		// fetch query object from the model with fields id, name, sortedName, equipmentQ, activeQ, hideQ
		$template['participants_list'] = $this->participants_model->fetch('participants','id, name, sortedName, equipmentQ, activeQ, hideQ','','',$sortby);

		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/browse/';
		$template['edit_url']   = 'concentric/participants/edit/';
		$template['delete_url'] = 'concentric/participants/delete/';
		$template['add_url']    = 'concentric/participants/add/';
		$template['cancel_url'] = 'concentric/home';
		$template['sort_url']['Name']        = 'concentric/participants/browse/name';
		$template['sort_url']['SortedName']  = 'concentric/participants/browse/sortedname';
		$template['sort_url']['Equipment']   = 'concentric/participants/browse/equipment';
		$template['sort_url']['Active']      = 'concentric/participants/browse/active';
		$template['sort_url']['Fake']        = 'concentric/participants/browse/hide';
		$template['sort']['name']            = $sortname;
		$template['sort']['direction']       = $sortdirection;

		// Set breadcrumb
		$this->page->set_crumb('Participants',$template['base_url']);

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_grid', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	// Function: add()
	// Description: Prompts user for input and adds a new entry
	//              in the database.
	function add()
	{
		$this->_modify('add');
	}

	// -------------------------------------------------------------------------
	// Function: edit()
	// Description: Prompts user for input and updates an entry
	//              in the database.
	function edit()
	{
		$this->_modify('edit');
	}

	// -------------------------------------------------------------------------
	// Function: modify()
	// Description: Prompts user for input and adds/edits an entry
	//              in the database. Default to add mode.
	function _modify($mode = 'add')
	{
		// Initialize variable
		$other_scripts_data = '';

		// load validation library to help validate data
		$this->load->library('validation');

		// Set breadcrumb
		$this->page->set_crumb('Participants','concentric/participants/');
		$this->page->set_crumb('Details','concentric/participants/' . $mode);

		// create urls and values for use in content view
		$template['form_url'] = 'concentric/participants/' . $mode . '/';
		$template['cancel_url'] = 'concentric/participants/browse';
		$template['form_attributes'] = array( 'method' => 'post', 'id' => $this->form_name, 'name' => $this->form_name );
		$template['header']  = $this->form_name;
		//if ($mode == 'add')
		//{
			$template['submit_button_name']  = 'Save';
		//} else {
		//	$template['submit_button_name']  = 'Save and Next';
		//}

		// create html to use the editor
		$editor_url = $this->config->item('base_url') . 'assets/tiny_mce/';
		$other_scripts_data .= $this->_tinymce_scripts($editor_url);


		$this->_initialize();   // Setup the fields
		$this->_validation();   // Load the validation rules and fields


		// if validation has not run or if it failed
		if ( $this->validation->run() == FALSE )
		{
			// Save validation errors to flashmsg
			// Will be output in content view by status->display
			$this->validation->output_errors();

			// Get values for form fields and build the form fields
			$status = $this->_get_form_values($mode);

			// If the returned values got an error
			if ($status === FALSE)
			{
				// Show error message
				flashMsg('error','There was a problem editing that record.');
				// redirect to main location
				redirect('/concentric/participants/', 'location');
			}

			// Save field data to array to be passed to content view
			$template['fields'] = $this->fields;

			// build content html using details view and template data
			$data['content'] = $this->load->view('/concentric/details', $template, TRUE);
			// pass other scripts data to container
			$data['other_scripts'] = $other_scripts_data;

			// pass all data to container view and display to user
			$this->load->view($this->_container, $data);
		}
		else  // User is submitting valid data
		{
			// Store the values from the form into the db

			// XXS Filtering enforced for user input
			$data['field']['id']			= $this->input->post('id', TRUE);
			$data['field']['name']			= $this->input->post('name', TRUE);
			$data['field']['sortedName']	= $this->input->post('sortedName', TRUE);
			$data['field']['address1']		= $this->input->post('address1', TRUE);
			$data['field']['address2']		= $this->input->post('address2', TRUE);
			$data['field']['city']			= $this->input->post('city', TRUE);
			$data['field']['state']			= $this->input->post('state', TRUE);
			$data['field']['postalCode']	= $this->input->post('postalCode', TRUE);
			$data['field']['country']		= $this->input->post('country', TRUE);
			$data['field']['email']			= $this->input->post('email', TRUE);
			$data['field']['phoneNumber']	= $this->input->post('phoneNumber', TRUE);
			$data['field']['bio']			= $this->input->post('bio', TRUE);
			$data['field']['notes']			= $this->input->post('notes', TRUE);
			$data['field']['proGOHQ']		= $this->input->post('proGOHQ', TRUE);
			$data['field']['equipmentQ']	= $this->input->post('equipmentQ', TRUE);
			$data['field']['activeQ']		= $this->input->post('activeQ', TRUE);
			$data['field']['hideQ']			= $this->input->post('hideQ', TRUE);

			if ($mode == 'add')
			{
				// add the data to the table and return id
				$idField = $this->participants_model->addRow('participants',$data['field']);
				$status = ($idField) ? TRUE : FALSE;
			}
			else
			{
				$idField = $data['field']['id'];
				// update the data in the table
				$obj = $this->participants_model->update('participants', $data['field'], 'id = ' . $idField);
				$status = ($obj) ? TRUE : FALSE;
			}

			// if there was no error in add or edit
			if ($status)
			{
				// Show success message
				flashMsg('success','Record ' . $idField . ' (' . $data['field']['name'] . ') has been saved.');
			}
			else  // there was an error
			{
				// Show error message
				flashMsg('error','The record for (' . $data['field']['name'] . ') has not been saved.');
			}

			// if editing, get next id based on sorted name and redirect back to edit
			/*
			if ($mode == 'edit')
			{
				$nextId = $this->participants_model->getNextBySortedName($data['field']['sortedName']);

				// if no more ids, then go back to main location
				if ($nextId == 0)
				{
					redirect('/concentric/participants/', 'location');
				}

				redirect('/concentric/participants/edit/' . $nextId, 'location');
			}
			*/

			// redirect to main location
			redirect('/concentric/participants/', 'location');
			// ?redirect to add/edit?
			// redirect('/concentric/participants/' . $mode . '/', 'location');
		}
	}

	// -------------------------------------------------------------------------
	// Function: delete()
	// Description: Controller function to process user delete requests
	function delete()
	{
		$idField = $this->uri->segment(4);

		//$confirm = $this->_delete_confirm($idField);  //add later
		$confirm = TRUE;

		if ($confirm)
		{
			if ( $this->participants_model->delete('participants', 'id =' . $idField) )
			{
				flashMsg('success', 'The record has been deleted.');
			}
			else
			{
				flashMsg('error', 'There was a problem deleting the record');
			}
		}

		redirect('/concentric/participants/', 'location');
	}

	// -------------------------------------------------------------------------
	function _delete_confirm($id)
	{
		//add later
	}

	// -------------------------------------------------------------------------
	// 
	function _get_form_values($mode = 'add')
	{
		if ($mode == 'add')
		{
			// Set empty values / default values
			$this->fields['id']['value'] = '';
			$this->fields['name']['value'] = '';
			$this->fields['sortedName']['value'] = '';
			$this->fields['address1']['value'] = '';
			$this->fields['address2']['value'] = '';
			$this->fields['city']['value'] = '';
			$this->fields['state']['value'] = '';
			$this->fields['postalCode']['value'] = '';
			$this->fields['country']['value'] = 'USA';
			$this->fields['email']['value'] = '';
			$this->fields['phoneNumber']['value'] = '';
			$this->fields['bio']['value'] = '';
			$this->fields['notes']['value'] = '';
			$this->fields['proGOHQ']['value'] = 1;
			$this->fields['proGOHQ']['checked'] = FALSE;
			$this->fields['equipmentQ']['value'] = 1;
			$this->fields['equipmentQ']['checked'] = FALSE;
			$this->fields['activeQ']['value'] = 1;
			$this->fields['activeQ']['checked'] = TRUE;
			$this->fields['hideQ']['value'] = 1;
			$this->fields['hideQ']['checked'] = FALSE;
		}
		else
		{
			//get the id from either the hidden field or the url
			$idField = ($this->input->post('id', TRUE) != '') ? $this->input->post('id', TRUE) : $this->uri->segment(4);

			// fetch query object from the model with all fields
			$qry = $this->participants_model->fetch('participants','id, name, sortedName, address1, address2, city, state, postalCode, country, email, phoneNumber, bio, notes, proGOHQ, equipmentQ, activeQ, hideQ','','id = ' . $idField);

			// There should only be 1 row. If not, return FALSE
			if ($qry->num_rows() != 1)
			{
				return FALSE;
			}

			// Get the single result as an array and save values
			$row = $qry->row_array();
			$this->fields['id']['value'] = $row['id'];
			$this->fields['name']['value'] = $row['name'];
			$this->fields['sortedName']['value'] = $row['sortedName'];
			$this->fields['address1']['value'] = $row['address1'];
			$this->fields['address2']['value'] = $row['address2'];
			$this->fields['city']['value'] = $row['city'];
			$this->fields['state']['value'] = $row['state'];
			$this->fields['postalCode']['value'] = $row['postalCode'];
			$this->fields['country']['value'] = $row['country'];
			$this->fields['email']['value'] = $row['email'];
			$this->fields['phoneNumber']['value'] = $row['phoneNumber'];
			$this->fields['bio']['value'] = $row['bio'];
			$this->fields['notes']['value'] = $row['notes'];
			$this->fields['proGOHQ']['value'] = 1;
			$this->fields['proGOHQ']['checked'] = ($row['proGOHQ']) ? TRUE : FALSE;
			$this->fields['equipmentQ']['value'] = 1;
			$this->fields['equipmentQ']['checked'] = ($row['equipmentQ']) ? TRUE : FALSE;
			$this->fields['activeQ']['value'] = 1;
			$this->fields['activeQ']['checked'] = ($row['activeQ']) ? TRUE : FALSE;
			$this->fields['hideQ']['value'] = 1;
			$this->fields['hideQ']['checked'] = ($row['hideQ']) ? TRUE : FALSE;
		}

		// Now build the form fields
		foreach ($this->fields as $field)
		{
			$this->fields[$field['name']]['form'] = build_form_field($field);
		}

		return TRUE;
	}


	// -------------------------------------------------------------------------
	function _validation()
	{

		// load the rules
		$form_rules['name']  = $this->fields['name']['rules'];
		$form_rules['sortedName']  = $this->fields['sortedName']['rules'];
		$form_rules['address1']  = $this->fields['address1']['rules'];
		$form_rules['address2']  = $this->fields['address2']['rules'];
		$form_rules['city']  = $this->fields['city']['rules'];
		$form_rules['state']  = $this->fields['state']['rules'];
		$form_rules['postalCode']  = $this->fields['postalCode']['rules'];
		$form_rules['country']  = $this->fields['country']['rules'];
		$form_rules['email']  = $this->fields['email']['rules'];
		$form_rules['phoneNumber']  = $this->fields['phoneNumber']['rules'];
		$form_rules['proGOHQ']  = $this->fields['proGOHQ']['rules'];
		$form_rules['equipmentQ']  = $this->fields['equipmentQ']['rules'];
		$form_rules['activeQ']  = $this->fields['activeQ']['rules'];
		$form_rules['hideQ']  = $this->fields['hideQ']['rules'];
		$this->validation->set_rules($form_rules);

		// load the field labels
		$form_fields['id']   = $this->fields['id']['label'];
		$form_fields['name'] = $this->fields['name']['label'];
		$form_fields['sortedName']   = $this->fields['sortedName']['label'];
		$form_fields['address1']  = $this->fields['address1']['label'];
		$form_fields['address2']  = $this->fields['address2']['label'];
		$form_fields['city']  = $this->fields['city']['label'];
		$form_fields['state']  = $this->fields['state']['label'];
		$form_fields['postalCode']  = $this->fields['postalCode']['label'];
		$form_fields['country']  = $this->fields['country']['label'];
		$form_fields['email']   = $this->fields['email']['label'];
		$form_fields['phoneNumber']   = $this->fields['phoneNumber']['label'];
		$form_fields['bio']   = $this->fields['bio']['label'];
		$form_fields['notes']   = $this->fields['notes']['label'];
		$form_fields['proGOHQ']   = $this->fields['proGOHQ']['label'];
		$form_fields['equipmentQ']   = $this->fields['equipmentQ']['label'];
		$form_fields['activeQ']   = $this->fields['activeQ']['label'];
		$form_fields['hideQ']   = $this->fields['hideQ']['label'];
		$this->validation->set_fields($form_fields);

		// set error delimiters
		$this->validation->set_error_delimiters('<span class="error">', '</span>');

	}


	// -------------------------------------------------------------------------
	/**
	 * Initalize Values
	 * 
	 * @access private
	 * @return void;
	 */
	function _initialize()
	{
		// Setup custom field options - list fields in the order they should
		// appear in the details view
		//   rules - validation rules (optional)
		//   label - descriptive name of the field (optional)
		//   name - database field name ** MUST BE SAME AS KEY ** (required)
		//   desc - long description to show to user on form (optional)
		//   type - set of values (required)
		//            text - basic input box
		//            hidden - keep this field hidden
		//            textarea
		//            checkbox
		//            dropdown
		//            password
		//   class - class name (optional)

		$this->fields['id'] = array('label' => 'Participant ID',
							'name' => 'id',
							'type' => 'hidden');
		$this->fields['name'] = array('rules' => 'trim|required|max_length[50]|xss_clean',
							'label' => 'Participant Name',
							'name' => 'name',
							'desc' => 'Enter the name of the participant as it should be displayed on reports.',
							'type' => 'text');
		$this->fields['sortedName'] = array('rules' => 'trim|required|max_length[50]|valid_person_name|callback__unique_field[participants.sortedName]|xss_clean',
							'label' => 'Participant Sorted Name',
							'name' => 'sortedName',
							'desc' => 'Enter the name of the participant as it should be sorted on reports. This must be a unique value.',
							'type' => 'text');
		$this->fields['address1'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'Address Line 1',
							'name' => 'address1',
							'desc' => 'Enter mailing address for the participant.',
							'type' => 'text');
		$this->fields['address2'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'Address Line 2',
							'name' => 'address2',
							'desc' => 'Enter mailing address for the participant.',
							'type' => 'text');
		$this->fields['city'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'City',
							'name' => 'city',
							'desc' => 'Enter mailing address for the participant.',
							'type' => 'text');
		$this->fields['state'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'State',
							'name' => 'state',
							'desc' => 'Enter mailing address for the participant.',
							'type' => 'text');
		$this->fields['postalCode'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'Postal Code',
							'name' => 'postalCode',
							'desc' => 'Enter mailing address for the participant.',
							'type' => 'text');
		$this->fields['country'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'Country',
							'name' => 'country',
							'desc' => 'Enter mailing address for the participant.',
							'type' => 'text');
		$this->fields['email'] = array('rules' => 'trim|max_length[50]|valid_emails|xss_clean',
							'label' => 'Participant Email',
							'name' => 'email',
							'desc' => 'Enter the email of the participant or a list of emails separated by commas.',
							'type' => 'text');
		$this->fields['phoneNumber'] = array('rules' => 'trim|max_length[50]|xss_clean',
							'label' => 'Participant Phone Number',
							'name' => 'phoneNumber',
							'desc' => 'Enter the phone number of the participant.',
							'type' => 'text');
		$this->fields['proGOHQ'] = array('rules' => 'trim|xss_clean',
							'label' => 'Pro Guest of Honor?',
							'name' => 'proGOHQ',
							'desc' => 'Is this participant the Pro Guest of Honor or have they been the Pro GOH in the past? If yes, this participant has a lifetime membership to the convention.',
							'type' => 'checkbox');
		$this->fields['equipmentQ'] = array('rules' => 'trim|xss_clean',
							'label' => 'Equipment?',
							'name' => 'equipmentQ',
							'desc' => 'Is this participant equipment?',
							'type' => 'checkbox');
		$this->fields['activeQ'] = array('rules' => 'trim|xss_clean',
							'label' => 'Active?',
							'name' => 'activeQ',
							'desc' => 'Is this participant active? Participants that are not active will not be printed on most reports.',
							'type' => 'checkbox');
		$this->fields['hideQ'] = array('rules' => 'trim|xss_clean',
							'label' => 'Fake?',
							'name' => 'hideQ',
							'desc' => 'Is this a fake participant that should be hidden on most reports? (I.E. Capricon\'s Lake Wobegon participants.)',
							'type' => 'checkbox');
		$this->fields['notes'] = array('label' => 'Participant Notes',
							'name' => 'notes',
							'desc' => 'Enter notes for participant that should be kept private.',
							'type' => 'textarea',
							'class' => 'mceNoEditor');
		$this->fields['bio'] = array('label' => 'Participant Bio',
							'name' => 'bio',
							'desc' => 'Enter the bio of the participant.',
							'type' => 'textarea',
							'class' => 'mceEditor');

		return;
	}

	/**
	 * Unique_field
	 * ** Assumes that the db model has already been loaded. **
	 *
	 * @access    private
	 * @param     string  The string to check for in the db.
	 * @param     field   The table and column of the field to check in table.column format
	 * @return    bool
	 */
	function _unique_field($str, $field)
	{
		list($table, $column) = split("\.", $field, 2);

		// Set the error message to use
		$this->validation->set_message('_unique_field','The %s field must have a unique value in the database.');

		$where= isset($_POST['id']) ? array('id !='=> $_POST['id'], $column=>$str) : array($column=>$str);
		$count = $this->participants_model->count_condition($table, $where);
		return ($count > 0) ? FALSE : TRUE;
	}

	//return html for tiny_mce editor script info
	// @access private
	// @return string html
	function _tinymce_scripts($url = '')
	{
		$str = "\n";
		$str .= '<script type="text/javascript" src="' . $url . 'tiny_mce.js"></script>' . "\n";
		$str .= '<script type="text/javascript">' . "\n";
		$str .= 'tinyMCE.init({' . "\n";
		$str .= '	mode : "textareas",' . "\n";
		$str .= '	theme : "advanced",' . "\n";
		$str .= '	editor_selector : "mceEditor",' . "\n";
		$str .= '	editor_deselector : "mceNoEditor",' . "\n";
		$str .= '	theme_advanced_buttons1 : "bold,italic,underline,|,bullist,numlist,|,undo,redo,cleanup,help",' . "\n";
		$str .= '	theme_advanced_buttons2 : "fontselect,fontsizeselect,|,blockquote,hr,code",' . "\n";
		$str .= '	theme_advanced_buttons3 : "",' . "\n";
		$str .= '	theme_advanced_toolbar_location : "top",' . "\n";
		$str .= '	theme_advanced_toolbar_align : "left",' . "\n";
		$str .= '	theme_advanced_statusbar_location : "bottom",' . "\n";
		$str .= '	theme_advanced_resizing : true' . "\n";
		$str .= '});' . "\n";
		$str .= '</script>' . "\n" . "\n";

		return $str;
	}


	// --------------------------------------------------------------------------------------------
	// Reports
	// --------------------------------------------------------------------------------------------

	// -------------------------------------------------------------------------
	/**
	* Reports Page
	*
	* @access      public
	* @return      none
	*/
	function reports()
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumb
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html
		$data['content'] = $this->load->view('/concentric/participants/participants_reports_menu', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report all data
	*
	* @access      public
	* @return      none
	*/
	function rep_all()
	{
		// fetch query object from the model with all fields
		$template['participants_list'] = $this->participants_model->fetch('participants','id, name, sortedName, address1, address2, city, state, postalCode, country, email, phoneNumber, proGOHQ, equipmentQ, activeQ, hideQ, bio, notes','','','sortedName ASC');

		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');
		$this->page->set_crumb('List All','concentric/participants/rep_all/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_list_all', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Download all data
	*
	* @access      public
	* @return      none
	*/
	function rep_download_all($eor = '')
	{
		// Load the helper
		$this->load->helper('download');

		// fetch query object from the model with all fields
		$query = $this->participants_model->fetch('participants','id, name, sortedName, address1, address2, city, state, postalCode, country, email, phoneNumber, proGOHQ, equipmentQ, activeQ, hideQ, bio, notes','','','id ASC');

		// Initialize values
		$data = '';
		$eor = ($eor == '') ? '' : (',' . $eor);
		// Loop through the data and build the data
		$data .= 'id,name,sortedName,address1,address2,city,state,postalCode,country,email,phoneNumber,proGOHQ,equipmentQ,activeQ,hideQ,bio,notes' . $eor . "\n";
		foreach ($query->result_array() as $row)
		{
			$data .= '"' . $row['id'] . '","' . $row['name'] . '","' . $row['sortedName'] . '","' . $row['address1'] . '","' . $row['address2'] . '","' . $row['city'] . '","' . $row['state'] . '","' . $row['postalCode'] . '","' . $row['country'] . '","' . $row['email'] . '","' . $row['phoneNumber'] . '","' . $row['proGOHQ'] . '","' . $row['equipmentQ'] . '","' . $row['activeQ'] . '","' . $row['hideQ'] . '","' . $row['bio'] . '","' . $row['notes'] . '"' . $eor . "\n";
		}

		// Download the file
		force_download('participants.csv', $data);

		redirect('/concentric/participants/reports', 'location');
	}

	// -------------------------------------------------------------------------
	/**
	* Report Participants Email
	*
	* @access      public
	* @return      none
	*/
	function rep_email($type = 'All')
	{
		$where = 'email is not null and email <>""';
		if ($type == 'Active')
			$where .= ' and activeQ = 1';

		// fetch query object from the model with fields id, name, sortedName, email
		$template['participants_list'] = $this->participants_model->fetch('participants','id, name, sortedName, email','',$where,'sortedName ASC');

		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');
		$this->page->set_crumb('List Email - '.$type,'concentric/participants/rep_email/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_list_email', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report active participants that are not hidden and not equipment
	*
	* @access      public
	* @return      none
	*/
	function rep_p_active()
	{
		// fetch query object from the model with fields id, name, sortedName, bio
		$template['participants_list'] = $this->participants_model->fetch('participants','id, name, sortedName, bio','','activeQ = 1 and hideQ = 0 and equipmentQ = 0','sortedName ASC');

		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');
		$this->page->set_crumb('Active Participants','concentric/participants/rep_p_active/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_p_active', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report to show participants schedules with email & phone - no equipment
	*
	* @access      public
	* @return      none
	*/
	function rep_schedule($mode = 'internal', $format = 'full')
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');
		$this->page->set_crumb('Active Participants Schedule','concentric/participants/rep_schedule/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = 'Participants Schedule Details';


		$this->load->helper('grid');    // load helper library
		$this->load->model('events_model');    // Instantiate the model
		$this->load->model('eventparticipants_model');    // Instantiate the model
		$this->load->model('eventlocations_model');    // Instantiate the model

		// fetch query object from the model - returns participant ids
		$where = 'participant.equipmentQ = 0';
		if ($mode != 'internal')
		{
			$where .= ' && event.hidePanelistsQ = 0';
		}
		$query = $this->eventparticipants_model->fetchScheduledParticipants($where);

		$template['content'] = '';  //initialize

		// loop thru participants and get details
		if ($query->num_rows() > 0)
		{
			foreach ($query->result_array() as $partrow)
			{
				// output participant details
				$template['content'] .= '<b><h3>' . $partrow['name'] . '</h3></b>' . '<br />' . "\n";
				if ($mode == 'internal')
				{
					if ($partrow['email'] != '')
						$template['content'] .= 'Email: ' . $partrow['email'] . '<br />' . "\n";
					if ($partrow['phoneNumber'] != '')
						$template['content'] .= 'Phone: ' . $partrow['phoneNumber'] . '<br />' . "\n";
				}
				$template['content'] .= '<br />' . "\n";


				// now get list of event ids for participant
				$query2 = $this->eventparticipants_model->fetchScheduledEvents('participant.id = '.$partrow['id'], 'event.startDateTime ASC');
				// loop thru events and get details
				foreach ($query2->result_array() as $eventrow)
				{
					// get event details
					$query3 = $this->events_model->fetch('events','name, startDateTime, description, eventLength','','id = '.$eventrow['id']);
					$eventdetailrow = $query3->row_array();
					$query3->free_result();

					// output event details
					$sdttm = strtotime($eventdetailrow['startDateTime']);  //start dttm
					$edttm = strtotime("+".($eventdetailrow['eventLength']*3600).' seconds', $sdttm);  //end dttm
					$eventdetailrow['endDateTime'] = date('Y-m-d H:i:s',$edttm);  //change back to sql
					$sdt = date('m-d-Y',$sdttm);
					$stm = $this->_gettime($eventdetailrow['startDateTime']);
					$etm = $this->_gettime($eventdetailrow['endDateTime']);
					$day = date("l",strtotime($eventdetailrow['startDateTime']));
					$locations = $this->eventlocations_model->convertLocationsToStrAlternate('event.id = '.$eventrow['id']);
					if (array_key_exists($eventrow['id'], $locations))
					{
						$template['content'] .= '<b>' . $eventdetailrow['name'] . ' - ' . $day . ', ' . $sdt . ' - ' . $stm . ' to ' . $etm . ' - ' . $locations[$eventrow['id']] . '</b>' . '<br />' . "\n";
					} else
					{
						$template['content'] .= '<b>' . $eventdetailrow['name'] . ' - ' . $day . ', ' . $sdt . ' - ' . $stm . ' to ' . $etm . ' - TBD </b>' . '<br />' . "\n";
					}
					if ($format == 'full')
					{
						$template['content'] .= $eventdetailrow['description'] . "\n";

						// now get list of other participants for this event
						$query3 = $this->eventparticipants_model->fetchScheduledParticipants2($where . ' && event.id = '.$eventrow['id']);
						if ($query3->num_rows > 0)
						{
							foreach ($query3->result_array() as $partlist)
							{
								$template['content'] .= '<i>' . $partlist['name'];
								if ($partlist['moderatorQ'] == 1)
									$template['content'] .= ' (M)';
								if ($mode == 'internal')
								{
									if ($partlist['email'] != '')
										$template['content'] .= ' - ' . $partlist['email'];
									if ($partlist['phoneNumber'] != '')
										$template['content'] .= ' - ' . $partlist['phoneNumber'];
								}
								$template['content'] .=  '</i>' . '<br />' . "\n";
							}
						}
						$query3->free_result();
						$template['content'] .= '<br />' . "\n";
					}
				}
				$query2->free_result();

				$template['content'] .= '<hr>' . "\n";
			}
		}


		// build content html using view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_generic', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	/**
	 * gettime
	 * Converts a SQL format date time to just time converted to hh:mi am/pm format.
	 *
	 * @access    private
	 * @param     string  The string that is a SQL datetime.
	 * @return    string Time in hh:mi am/pm format.
	 */
	function _gettime($dttm)
	{
		list($dt, $tm) = explode(' ', $dttm);  //separate into parts
		$tm1 = explode(':', $tm);  //separate time parts
		$tm = $tm1[0] . ':' . $tm1[1];  //remove seconds from time
		$tm = cnv_tm_from_military($tm);  //convert
		return $tm;
	}

	// -------------------------------------------------------------------------
	/**
	* Report to show participants schedules for labels
	*
	* @access      public
	* @return      none
	*/
	function rep_labels($format = 'all')
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');
		$this->page->set_crumb('Active Participants Labels','concentric/participants/rep_labels/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = 'Participants Labels';


		$this->load->helper('grid');    // load helper library
		$this->load->model('events_model');    // Instantiate the model
		$this->load->model('eventparticipants_model');    // Instantiate the model
		$this->load->model('eventlocations_model');    // Instantiate the model

		// fetch query object from the model - returns participant ids
		$where = 'participant.equipmentQ = 0';
		if ($format != 'all')
		{
			$where .= ' && event.hidePanelistsQ = 0';
		}
		$query = $this->eventparticipants_model->fetchScheduledParticipants($where);

		$template['content'] = '';  //initialize

		// loop thru participants and get details
		if ($query->num_rows() > 0)
		{
			foreach ($query->result_array() as $partrow)
			{
				// output participant details
				$template['content'] .= '<b><big>' . $partrow['name'] . '</big></b>' . '<br />' . "\n";

				// now get list of event ids for participant
				$query2 = $this->eventparticipants_model->fetchScheduledEvents('participant.id = '.$partrow['id'], 'event.startDateTime ASC');
				// loop thru events and get details
				foreach ($query2->result_array() as $eventrow)
				{
					// get event details
					$query3 = $this->events_model->fetch('events','name, startDateTime, description, eventLength','','id = '.$eventrow['id']);
					$eventdetailrow = $query3->row_array();
					$query3->free_result();

					// output event details
					$sdttm = strtotime($eventdetailrow['startDateTime']);  //start dttm
					$edttm = strtotime("+".($eventdetailrow['eventLength']*3600).' seconds', $sdttm);  //end dttm
					$eventdetailrow['endDateTime'] = date('Y-m-d H:i:s',$edttm);  //change back to sql
					$sdt = date('m-d-Y',$sdttm);
					$stm = $this->_gettime($eventdetailrow['startDateTime']);
					$etm = $this->_gettime($eventdetailrow['endDateTime']);
					$day = date("l",strtotime($eventdetailrow['startDateTime']));
					$locations = $this->eventlocations_model->convertLocationsToStrAlternate('event.id = '.$eventrow['id']);
					if (array_key_exists($eventrow['id'], $locations))
					{
						$template['content'] .= '<b>' . $day . ', ' . $stm . '-' . $etm . ' - ' . $locations[$eventrow['id']] . ' - ' . $eventdetailrow['name'] . '</b>' . '<br />' . "\n";
					} else
					{
						$template['content'] .= '<b>' . $day . ', ' . $stm . '-' . $etm . ' - TBD - ' . $eventdetailrow['name'] . '</b>' . '<br />' . "\n";
					}
				}
				$query2->free_result();

				$template['content'] .= '<br />' . "\n";
			}
		}


		// build content html using view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_generic', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report to show equipment schedules
	*
	* @access      public
	* @return      none
	*/
	function rep_schedule_equipment()
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/participants/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','concentric/participants/reports/');
		$this->page->set_crumb('Equipment Schedule','concentric/participants/rep_schedule_equipment/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = 'Equipment Schedule';


		$this->load->helper('grid');    // load helper library
		$this->load->model('events_model');    // Instantiate the model
		$this->load->model('eventparticipants_model');    // Instantiate the model
		$this->load->model('eventlocations_model');    // Instantiate the model

		// fetch query object from the model - returns participant ids
		$where = 'participant.equipmentQ = 1';
		$query = $this->eventparticipants_model->fetchScheduledParticipants($where);

		$template['content'] = '';  //initialize

		// loop thru participants and get details
		if ($query->num_rows() > 0)
		{
			foreach ($query->result_array() as $partrow)
			{
				// output participant details
				$template['content'] .= '<b><big>' . $partrow['name'] . '</big></b>' . '<br />' . "\n";
				$template['content'] .= '<br />' . "\n";


				// now get list of event ids for participant
				$query2 = $this->eventparticipants_model->fetchScheduledEvents('participant.id = '.$partrow['id'], 'event.startDateTime ASC');
				// loop thru events and get details
				foreach ($query2->result_array() as $eventrow)
				{
					// get event details
					$query3 = $this->events_model->fetch('events','name, startDateTime, description, eventLength','','id = '.$eventrow['id']);
					$eventdetailrow = $query3->row_array();
					$query3->free_result();

					// output event details
					$sdttm = strtotime($eventdetailrow['startDateTime']);  //start dttm
					$edttm = strtotime("+".($eventdetailrow['eventLength']*3600).' seconds', $sdttm);  //end dttm
					$eventdetailrow['endDateTime'] = date('Y-m-d H:i:s',$edttm);  //change back to sql
					$sdt = date('m-d-Y',$sdttm);
					$stm = $this->_gettime($eventdetailrow['startDateTime']);
					$etm = $this->_gettime($eventdetailrow['endDateTime']);
					$day = date("l",strtotime($eventdetailrow['startDateTime']));
					$locations = $this->eventlocations_model->convertLocationsToStrAlternate('event.id = '.$eventrow['id']);
					$template['content'] .= '<b>' . $eventdetailrow['name'] . ' - ' . $day . ', ' . $sdt . ' - ' . $stm . ' to ' . $etm . ' - ' . $locations[$eventrow['id']] . '</b>' . '<br />' . "\n";
				}
				$query2->free_result();

				$template['content'] .= '<hr>' . "\n";
			}
		}


		// build content html using view and template data
		$data['content'] = $this->load->view('/concentric/participants/participants_generic', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}




}

/* End of file participants.php */
/* Location: ./system/application/controllers/concentric/participants.php */