<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : settings.php
 *
 * DESCRIPTION   : settings module controller
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		settings component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Settings extends Concentric_Controller
{
	/**
	* Constructor
	*/
	function Settings()
	{
		// Call parent constructor
		parent::Concentric_Controller();

		log_message('debug','ConCentric Settings Class Initialized'); 
	}

	function index()
	{
		$this->load->module_model('auth','access_control_model');
		// Setup the form
		$config['form_name'] = "Programming Configuration";
		$config['form_link'] = 'concentric/settings/index';
		$config['form_attributes'] = array('name' => 'settings');

		$cal_url = $this->config->item('base_url') . 'assets/tigra_calendar/';
		$editor_url = $this->config->item('base_url') . 'assets/tiny_mce/';

		// Setup groups
		$config['group'] = array(
			'general'		=> array(
				'name'=> "Programming Settings",
				'fields'=>'convention_name,start_date_time,end_date_time,interval_length,draft_mode_q'
				),
			'hours'		=> array(
				'name'=> "Department Hours",
				'fields'=>'hours'
				),
			'help'		=> array(
				'name'=> "Programming Help",
				'fields'=>'programming_help'
				)
		);


		// Setup custom field options
		$config['field']['convention_name'] = array('rules'=>'trim|required');
		$config['field']['start_date_time'] = array('rules'=>'trim|required|valid_textdatetime', 'script'=>$this->_calendar_link('start_date_time',$cal_url), 'after_form_script'=>$this->_calendar_picker('start_date_time',$config['form_attributes']['name'],$cal_url));
		$config['field']['end_date_time'] = array('rules'=>'trim|required|valid_textdatetime', 'script'=>$this->_calendar_link('end_date_time',$cal_url), 'after_form_script'=>$this->_calendar_picker('end_date_time',$config['form_attributes']['name'],$cal_url));
		$config['field']['interval_length'] = array('rules'=>'callback__check_events', 'type'=>'dropdown','params'=>array('options'=>array('900'=>'15 minute intervals','1800'=>'30 minute intervals','3600'=>'60 minute intervals')));
		$config['field']['draft_mode_q'] = array('type'=>'boolean');

		$config['field']['hours'] = array('type'=>'textarea','params'=>array('cols'=>'180','rows'=>'20'));

		$config['field']['programming_help'] = array('type'=>'textarea','params'=>array('cols'=>'180','rows'=>'20'));


		$other_data = '';
		$other_data .= $this->_tinymce_scripts($editor_url);
		$other_data .= $this->_calendar_script($cal_url);


		// Display the form
		$this->load->module_library('ccsettings','ccsettings_form');
		$this->ccsettings_form->initalize($config);
		$data['header'] = $this->ccsettings_form->form_name;
		$data['content'] = $this->ccsettings_form->display();
		$data['other_scripts'] = $other_data;
		$this->load->view($this->_container,$data);
	}

	//return html for tiny_mce editor script info
	// @access private
	// @return string html
	function _tinymce_scripts($url = '')
	{
		$str = "\n";
		$str .= '<script type="text/javascript" src="' . $url . 'tiny_mce.js"></script>' . "\n";
		$str .= '<script type="text/javascript">' . "\n";
		$str .= 'tinyMCE.init({' . "\n";
		$str .= '	mode : "textareas",' . "\n";
		$str .= '	theme : "advanced",' . "\n";
		$str .= '	theme_advanced_buttons1 : "bold,italic,underline,|,bullist,numlist,|,undo,redo,cleanup,help",' . "\n";
		$str .= '	theme_advanced_buttons2 : "fontselect,fontsizeselect,|,blockquote,hr,code",' . "\n";
		$str .= '	theme_advanced_buttons3 : "",' . "\n";
		$str .= '	theme_advanced_toolbar_location : "top",' . "\n";
		$str .= '	theme_advanced_toolbar_align : "left",' . "\n";
		$str .= '	theme_advanced_statusbar_location : "bottom",' . "\n";
		$str .= '	theme_advanced_resizing : true' . "\n";
		$str .= '});' . "\n";
		$str .= '</script>' . "\n" . "\n";

		return $str;
	}

	// @access private
	// @return string html
	function _calendar_script($url = '')
	{
		$str = "\n";
		$str .= '<script language="JavaScript" src="' . $url . 'calendar3.js"></script>' . "\n";

		return $str;
	}

	// @access private
	// @return string html
	function _calendar_picker($element = 'cal', $name = '', $url = '')
	{
		$str = "\n";
		$str .= '<script language="JavaScript">' . "\n";
		$str .= '	var cal_' . $element . ' = new calendar3(document.forms["' . $name . '"].elements["' . $element . '"]);' . "\n";
		$str .= '	cal_' . $element . '.year_scroll = true;' . "\n";
		$str .= '	cal_' . $element . '.time_comp = true;' . "\n";
		$str .= '	cal_' . $element . '.location = "' . $url . '";' . "\n";
		$str .= '</script>' . "\n";

		return $str;
	}

	// @access private
	// @return string html
	function _calendar_link($element = 'cal', $url = '')
	{
		$str = '';
		$str = '<a href="javascript:cal_' . $element . '.popup();"><img src="' . $url . 'img/cal.gif" width="16" height="16" border="0" alt="Click here to pick the date"></a>';
		return $str;
	}

	/**
	 * Check to see if there have already been events scheduled
	 *
	 * @access    private
	 * @param     string  The string to check.
	 * @return    bool
	 */
	function _check_events($str)
	{
		// Set the error message to use
		$this->validation->set_message('_check_events','The %s field cannot be changed since events have already been scheduled.');

		// load models
		$this->load->model('events_model');
		$this->load->module_model('ccsettings','ccsettings_model','ccsettings');

		// get count of scheduled events
		$cnt = $this->events_model->count_condition('events','startDateTime != "0000-00-00 00:00:00"');

		// get current interval setting
		$curval = $this->ccsettings->item('interval_length');

		// if no change in values, good
		if ($curval == $str)
			return TRUE;

		// if events scheduled, bad
		if ($cnt > 0)
			return FALSE ;

		// else good
		return TRUE;
	}

}


/* End of file settings.php */
/* Location: ./system/application/controllers/concentric/settings.php */