<?php if (!defined('BASEPATH')) exit('No direct script access allowed');  

/**
 * ConCentric - Reports
 *
 * Public reports controller
 *
 * @package			ConCentric
 * @subpackage      Controllers
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2009
 * @license			http://www.gnu.org/licenses/gpl.html
 * @link			http://www.verhulstconsulting.com
 */

// ---------------------------------------------------------------------------

class Reports extends Public_Controller
{
	function Reports()
	{
		// Call parent constructor
		parent::Public_Controller();

		$this->form_name = "Reports";
		$this->load->model('events_model');    // Instantiate the model
		// load helper library
		$this->load->helper('concentric');
	}

	function index()
	{
		// The default action is the menu
		$this->menu();
	}

	// -------------------------------------------------------------------------
	/**
	* Reports Page
	*
	* @access      public
	* @return      none
	*/
	function menu()
	{
		// create urls for use in content view
		$template['base_url']   = 'reports/';
		$template['cancel_url'] = 'reports/';

		// Set breadcrumb
		$this->page->set_crumb('Reports','public/reports/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build html for list of events by category
		$template['list_events_by_category'] = $this->_get_list_events_by_category();

		// build content html
		$data['content'] = $this->load->view('/public/reports/reports_menu', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view('public/cc_container.php',$data);
	}

	// -------------------------------------------------------------------------
	/**
	 * Build html to call reports by category
	 *
	 * @access    private
	 * @return    html string
	 */
	function _get_list_events_by_category()
	{
		// Load the model
		$this->load->model('categories_model');

		// fetch query object from the model with fields
		$query = $this->categories_model->fetch('categories','id, name','','','name ASC');

		// Loop through to build string
		$data = "\n";
		foreach ($query->result_array() as $row)
		{
			$data .= '<li>' . anchor("reports/publicreports/" . $row['name'],"Report of " . $row['name'] . " Events") . '</li>' . "\n";
		}

		return $data;
	}

	// -------------------------------------------------------------------------
	/**
	* Report grid of scheduled events
	*
	* @access      public
	* @return      none
	*/
	function grid_scheduled_events($mode = 'internal', $timespan = 'default')
	{
		// load grid helper
		$this->load->helper('grid');

		// create urls for use in content view
		$template['base_url']   = 'reports/';

		// Set breadcrumbs
		$this->page->set_crumb('Reports','reports/');
		$this->page->set_crumb('Grid of Scheduled Events','reports/grid_scheduled_events');

		// set values for use in content view
		$template['header'] = $this->form_name;

		// interval to use for grid is default
		$grid_interval = $this->ccsettings->item('interval_length');

		// setup where clause for locations query
		$where = array('publicQ'=>'1');

		// Need to create a list of locations for grid
		$this->load->model('locations_model');    // Instantiate the model
		$query = $this->locations_model->fetch('locations', 'id, sortOrder', '', $where, 'sortOrder ASC');  //get data
		foreach ($query->result_array() as $row)
		{
			$locations[$row['sortOrder']] = $row['id'];
		}
		$this->locationGrid = $this->events_model->build_location_grid($locations, 'public', $grid_interval);  // Build the location grid
		$template['content'] = output_locationgrid($this->locationGrid, $locations, 'public');


		// build content html using grid view and template data
		$data['content'] = $this->load->view('/public/reports/events_reports_grid', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view('public/cc_container.php',$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Various Reports for public data
	*
	* @access      public
	* @return      none
	*/
	function publicreports($cat = 'all', $sort = 'dttm', $sched = '')
	{
		// include only public report tracks
		$where = 'track.publicQ = 1';
		$where .= ' AND event.hideQ = 0';
		$where .= ' AND event.activeQ = 1';
		if ($sched == 'sched')
		{
			$where .= ' AND event.startDateTime != "0000-00-00 00:00:00"';
		}
		if ($cat != 'all')
		{
			$where .= ' AND category.name = "' . $cat . '"';
		}

		// include only regular panelists
		$where1 = 'participant.equipmentQ = 0';

		// determine sort - default is alphabetically
		if ($sort == 'alpha')
		{
			$sortby = 'event.name ASC';
			$template['sort_method'] = 'Alphabetically';
		} elseif ($sort == 'dttm')
		{
			$sortby = 'event.startDateTime ASC, event.name ASC';
			$template['sort_method'] = 'by Date/Time';
		} else
		{
			$sortby = 'event.name ASC';
			$template['sort_method'] = 'Alphabetically';
		}

		$this->load->model('eventlocations_model');    // Instantiate the model
		$this->load->model('eventparticipants_model');    // Instantiate the model

		// fetch query objects from the models
		$template['events_list'] = $this->events_model->fetchEvents($where, $sortby);
		$eventparticipants_list = $this->eventparticipants_model->fetchEventParticipants($where1);

		$template['eventlocations_array'] = $this->eventlocations_model->convertLocationsToStr();
		$template['eventparticipants_array'] = $this->eventparticipants_model->convertParticipantsToStr($where1, 'participant.sortedName ASC', 'public');

		// create urls for use in content view
		$template['base_url']   = 'reports/';
		$template['cancel_url'] = 'reports/';

		// Set breadcrumbs
//		$this->page->set_crumb('Reports','reports/');
//		($cat == 'all') ? $this->page->set_crumb('All Events','concentric/events/publicreports/' . $cat . '/') : $this->page->set_crumb($cat . ' Events','concentric/events/publicreports/' . $cat . '/') ;

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;
		$template['mode'] = 'public';

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/public/reports/events_list', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view('public/cc_container.php',$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report to show active participants schedules - no equipment
	*
	* @access      public
	* @return      none
	*/
	function rep_schedule($format = 'full')
	{
		// create urls for use in content view
		$template['base_url']   = 'reports/';
		$template['cancel_url'] = 'reports/';

		// Set breadcrumbs
		$this->page->set_crumb('Participant Reports','reports/');
		$this->page->set_crumb('Active Participants Schedule','reports/rep_schedule/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = 'Participants Schedule Details';

		if ($format <> 'full')
		{
			$template['header'] .= ' - Condensed';
		}

		$this->load->helper('grid');    // load helper library
		$this->load->model('events_model');    // Instantiate the model
		$this->load->model('eventparticipants_model');    // Instantiate the model
		$this->load->model('eventlocations_model');    // Instantiate the model

		// fetch query object from the model - returns participant ids
		$where = 'participant.equipmentQ = 0';
		$where .= ' && event.hidePanelistsQ = 0';
		$query = $this->eventparticipants_model->fetchScheduledParticipants($where);

		$content = '';  //initialize
		$header = '';  //initialize

		// loop thru participants and get details
		if ($query->num_rows() > 0)
		{
			foreach ($query->result_array() as $partrow)
			{
				$header .= '<b><a name="#id' . $partrow['id'] . '">' . $partrow['name'] . '</a></b>' . '<br />' . "\n";

				// output participant details
				$content .= '<b><a name="id' . $partrow['id'] . '"><h3>' . $partrow['name'] . '</h3></a></b>' . '<br />' . "\n";
				$content .= '<br />' . "\n";


				// now get list of event ids for participant
				$query2 = $this->eventparticipants_model->fetchScheduledEvents('participant.id = '.$partrow['id'], 'event.startDateTime ASC');
				// loop thru events and get details
				foreach ($query2->result_array() as $eventrow)
				{
					// get event details
					$query3 = $this->events_model->fetch('events','name, startDateTime, description, eventLength','','id = '.$eventrow['id']);
					$eventdetailrow = $query3->row_array();
					$query3->free_result();

					// output event details
					$sdttm = strtotime($eventdetailrow['startDateTime']);  //start dttm
					$edttm = strtotime("+".($eventdetailrow['eventLength']*3600).' seconds', $sdttm);  //end dttm
					$eventdetailrow['endDateTime'] = date('Y-m-d H:i:s',$edttm);  //change back to sql
					$sdt = date('m-d-Y',$sdttm);
					$stm = $this->_gettime($eventdetailrow['startDateTime']);
					$etm = $this->_gettime($eventdetailrow['endDateTime']);
					$day = date("l",strtotime($eventdetailrow['startDateTime']));
					$locations = $this->eventlocations_model->convertLocationsToStrAlternate('event.id = '.$eventrow['id']);
					if (array_key_exists($eventrow['id'], $locations))
					{
						$content .= '<b>' . $eventdetailrow['name'] . ' - ' . $day . ', ' . $sdt . ' - ' . $stm . ' to ' . $etm . ' - ' . $locations[$eventrow['id']] . '</b>' . '<br />' . "\n";
					} else
						$content .= '<b>' . $eventdetailrow['name'] . ' - ' . $day . ', ' . $sdt . ' - ' . $stm . ' to ' . $etm . ' - TBD </b>' . '<br />' . "\n";
					{
					}
					if ($format == 'full')
					{
						$content .= $eventdetailrow['description'] . "\n";

						// now get list of other participants for this event
						$query3 = $this->eventparticipants_model->fetchScheduledParticipants2($where . ' && event.id = '.$eventrow['id']);
						if ($query3->num_rows > 0)
						{
							foreach ($query3->result_array() as $partlist)
							{
								$content .= '<i>' . $partlist['name'];
								if ($partlist['moderatorQ'] == 1)
									$content .= ' (M)';
								$content .=  '</i>' . '<br />' . "\n";
							}
						}
						$query3->free_result();
						$content .= '<br />' . "\n";
					}
				}
				$query2->free_result();

				$content .= '<hr>' . "\n";
			}
		}


		$template['content'] = $header . "\n" . '<br /><br />' . $content;

		// build content html using view and template data
		$data['content'] = $this->load->view('/public/reports/participants_generic', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view('public/cc_container.php',$data);
	}

	/**
	 * gettime
	 * Converts a SQL format date time to just time converted to hh:mi am/pm format.
	 *
	 * @access    private
	 * @param     string  The string that is a SQL datetime.
	 * @return    string Time in hh:mi am/pm format.
	 */
	function _gettime($dttm)
	{
		list($dt, $tm) = explode(' ', $dttm);  //separate into parts
		$tm1 = explode(':', $tm);  //separate time parts
		$tm = $tm1[0] . ':' . $tm1[1];  //remove seconds from time
		$tm = cnv_tm_from_military($tm);  //convert
		return $tm;
	}

}


/* End of file reports.php */
/* Location: ./system/application/controllers/reports.php */