<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : MY_form_helper.php
 *
 * DESCRIPTION   : MY form helper
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-11 13:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		my form helper Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

/**
 * MY_form_helper from xwero
 *
 * Create new versions of the form helper functions that improve them by
 *   automatically getting the data that may have been entered by the user.
 * Created by xwero on 15 May 2008.
 * Copied by Leane Verhulst from CodeIgniter - http://codeigniter.com/wiki/MY_form_helper/
 */

log_message('debug','MY_form_helper');

function form_hidden($name, $value = '')
{
	if ( ! is_array($name))
	{
		$value = (isset($_POST[$name]))?$_POST[$name]:((isset($_GET[$name]))?$_GET[$name]:$value);
		return '<input type="hidden" name="'.$name.'" value="'.form_prep($value).'" />';
	}

	$form = '';
	foreach ($name as $name => $value)
	{
		$value = (isset($_POST[$name]))?$_POST[$name]:((isset($_GET[$name]))?$_GET[$name]:$value);
		$form .= '<input type="hidden" name="'.$name.'" value="'.form_prep($value).'" />';
	}

	return $form;
}

function form_input($data = '', $value = '', $extra = '')
{
	$name = ( ! is_array($data))?$data:((isset($data['name']))?$data['name']:'');
	$value = (isset($_POST[$name]))?$_POST[$name]:((isset($_GET[$name]))?$_GET[$name]:$value);
	$defaults = array('type' => 'text', 'name' => (( ! is_array($data)) ? $data : ''), 'value' => $value, 'maxlength' => '500', 'size' => '50');

	return "<input ".parse_form_attributes($data, $defaults).$extra." />\n";
}

function form_textarea($data = '', $value = '', $extra = '')
{
	$name = ( ! is_array($data))?$data:((isset($data['name']))?$data['name']:'');
	$defaults = array('name' => (( ! is_array($data)) ? $data : ''), 'cols' => '90', 'rows' => '12');

	if ( ! is_array($data) OR ! isset($data['value']))
	{
		$val = (isset($_POST[$name]))?$_POST[$name]:((isset($_GET[$name]))?$_GET[$name]:$value);
	}
	else
	{
		$val = (isset($_POST[$name]))?$_POST[$name]:((isset($_GET[$name]))?$_GET[$name]:$data['value']);
		unset($data['value']); // textareas don't use the value attribute
	}

	return "<textarea ".parse_form_attributes($data, $defaults).$extra.">".$val."</textarea>\n";
}

function form_dropdown($name = '', $options = array(), $selected = '', $extra = '')
{
	if ($extra != '') $extra = ' '.$extra;

	$form = '<select name="'.$name.'"'.$extra.">\n";

	foreach ($options as $key => $val)
	{
		$key = (string) $key;
		$val = (string) $val;

		$name = str_replace('[]','',$name);
		$send = (isset($_POST[$name]))?$_POST[$name]:((isset($_GET[$name]))?$_GET[$name]:$selected);

		$sel = (is_array($send) && in_array($key, $send))?' selected="selected"':(($key == $send)?' selected="selected"':'');

		$form .= '<option value="'.$key.'"'.$sel.'>'.$val."</option>\n";
	}

	$form .= '</select>';

	return $form;
}

function form_checkbox($data = '', $value = '', $checked = FALSE, $extra = '')
{
	$name = ( ! is_array($data))?$data:((isset($data['name']))?$data['name']:'');
	$defaults = array('type' => 'checkbox', 'name' => (( ! is_array($data)) ? $data : ''), 'value' => $value);

	if (is_array($data) AND array_key_exists('checked', $data))
	{
		$checked = (isset($_POST[$name]))?TRUE:((isset($_GET[$name]))?TRUE:$data['checked']);

		if ($checked == FALSE)
		{
			unset($data['checked']);
		}
		else
		{
			$data['checked'] = 'checked';
		}
	}

	$checked = (isset($_POST[$name]))?TRUE:((isset($_GET[$name]))?TRUE:$checked);
	if ($checked == TRUE)
		$defaults['checked'] = 'checked';
	else
		unset($defaults['checked']);

	return "<input ".parse_form_attributes($data, $defaults).$extra." />\n";
}

function form_radio($data = '', $value = '', $checked = FALSE, $extra = '')
{
	if ( ! is_array($data))
	{
		$data = array('name' => $data);
	}

	$data['type'] = 'radio';
	return form_checkbox($data, $value, $checked, $extra);
}

/**
 * End of MY_form_helper from xwero
 */

// -----------------------------------------------------------------------------------

/**
 * Build the form field using data set in an array
 * Keys are: name
 *           value
 *           type
 *           checked
 *           options
 *           selected
 */
function build_form_field($data = '')
{
	if ( ! is_array($data))
	{
		$data = array('name' => $data, 'type' => 'text', 'value' => '');
	}

	// initialize value to an empty string
	$form = '';

	switch ($data['type'])
	{
		case 'hidden':
			$form = form_hidden( $data['name'], $data['value']);
			break;
		case 'textarea':
			$array = array(
				'name' => $data['name'],
				'id' => $data['name'],
				'value' => $data['value'],
				'class' => (isset($data['class']) ? $data['class'] : '')
			);
			$extra = (isset($data['scripts']) ? $data['scripts'] : '');
			$form = form_textarea( $array, NULL, $extra);
			break;
		case 'checkbox':
			$checked = ($data['checked']) ? TRUE : FALSE;
			$array = array(
				'name' => $data['name'],
				'id' => $data['name'],
				'value' => $data['value'],
				'checked' => $checked,
				'class' => (isset($data['class']) ? $data['class'] : '')
			);
			$extra = (isset($data['scripts']) ? $data['scripts'] : '');
			$form = form_checkbox( $array, NULL, NULL, $extra );
			break;
		case 'dropdown':
			$extra = (isset($data['scripts']) ? $data['scripts'] : '');
			$form = form_dropdown( $data['name'], $data['options'], $data['selected'], $extra );
			break;
		case 'password':
			$array = array(
				'name' => $data['name'],
				'id' => $data['name'],
				'value' => $data['value'],
				'class' => (isset($data['class']) ? $data['class'] : '')
			);
			$extra = (isset($data['scripts']) ? $data['scripts'] : '');
			$form = form_password( $array, NULL, $extra );
			break;
		default:
			// default to text type
			$array = array(
				'name' => $data['name'],
				'id' => $data['name'],
				'value' => $data['value'],
				'class' => (isset($data['class']) ? $data['class'] : '')
			);
			$extra = (isset($data['scripts']) ? $data['scripts'] : '');
			$form = form_input( $array, NULL, $extra );
	}

	return $form;
}

/* End of file MY_form_helper.php */
/* Location: ./system/application/libraries/MY_form_helper.php */