<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : ConCentric_helper.php
 *
 * DESCRIPTION   : concentric helper
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-11 13:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		concentric helper Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

/**
 * Return an array of dates and times between 2 dates using a specific interval
 *
 * @access public
 * @params str		$sdttm date/time in mySQL format
 * @params str		$edttm date/time in mySQL format
 * @params int		$int interval to use in seconds
 * @return array
 */
function datetime_array($sdttm = '', $edttm = '', $int = 900)
{
	// ensure that dates are sent
	if ($sdttm == '' OR $edttm == '')
		return FALSE;

	list($sdt, $stm) = explode(' ', $sdttm);
	list($edt, $etm) = explode(' ', $edttm);

	// convert time to number of seconds
	$stm = timeval($stm);
	$etm = timeval($etm);

	// initialize dates array and set first value to blank
	$dates=Array();
	$dates[] = '';

	// loop through dates and build array
	$i=0;
	while ( strtotime($edt) >= strtotime("+".$i." day",strtotime($sdt)) )
	{
		$dt=date("Y-m-d",strtotime("+".$i++." day",strtotime($sdt)));
		$slptm = 0;
		$elptm = 86400;
		if ($dt == $sdt) 
			$slptm = $stm;  // override start loop time on start date
		if ($dt == $edt)
			$elptm = $etm;  // override end loop time on end date

		// loop thru time starting at start time and ending at end time by interval
		$j = $slptm;
		for ($j = $slptm; $j <= ($elptm - $int); $j = $j + $int)
		{
			$h = floor($j / 3600);
			$m = ($j - ($h*3600)) / 60;
			$dates[]=$dt . " " . date("H:i:s", mktime($h, $m, 0));
		}
	}

	return $dates;
}


// --------------------------------------------------------------------------------------------
/**
 * Convert hh:mm:ss time to seconds
 *
 * @access public
 * @params string	$tm string of time in 00:00:00 format
 * @return integer	time in seconds
 */
function timeval($tm)
{
	$tm = explode(':', $tm);
	$tm = ($tm[0] * 60 * 60) + ($tm[1] * 60) + $tm[2];
	return $tm;
}

// --------------------------------------------------------------------------------------------
/**
 * Round the time up to make it evenly divisible by the interval
 *
 * @access public
 * @params integer	$tm time in seconds
 * @params integer	$int 
 * @return integer	time in seconds
 */
function match_interval($tm, $int)
{
	while (($tm % $int) <> 0)
	{
		$tm = $tm + 900;  // add 15 minutes to time
	}
	return $tm;
}

// --------------------------------------------------------------------------------------------
/**
 * Set the sort cookie
 *
 * @access  public
 * @params  array  $data  An array of an array of sort parameters
 */
function set_sort_cookie($data)
{
	set_cookie('sort',			// name of the cookie
		serialize($data),		// serialize the array
		7*86400,				// keep for 7 days
		NULL,					// domain
		'/',					// path
		'cc_'					// prefix of the cookie
	);

	return TRUE;
}


/**
 * Figure out the way to sort the events grid
 *
 * @access  public
 * @params  string  $sortby  Name of the field to sort by
 * @return  array   array of sort information
 */
function get_events_sort($sortby = '')
{
	// initialize variables
	$sortfield = '';
	$sortdirection = '';
	$sortname = '';

	// get currentsorts from cookie
	if ( FALSE !== ($currentsorts = get_cookie('cc_sort')) )
	{
		$currentsorts = unserialize($currentsorts);
		if ( isset($currentsorts['events']) )
		{
			$sortfield = $currentsorts['events']['field'];			// sql field name from model
			$sortdirection = $currentsorts['events']['direction'];	// direction to sort
			$sortname = $currentsorts['events']['name'];			// User name for field
		}
	}

	// determine how to sort the grid
	// sortname MUST match the sort_url names in the controller
	switch ($sortby) {
		case "name":
			$sortname = 'Name';
			if ( $sortfield == 'event.name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'event.name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'event.name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'event.name ASC';
				$sortfield = 'event.name';
				$sortdirection = 'ASC';
			}
			break;
		case "category":
			$sortname = 'Category';
			if ( $sortfield == 'category_name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'category_name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'category_name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'category_name ASC';
				$sortfield = 'category_name';
				$sortdirection = 'ASC';
			}
			break;
		case "track":
			$sortname = 'Track';
			if ( $sortfield == 'track_name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'track_name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'track_name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'track_name ASC';
				$sortfield = 'track_name';
				$sortdirection = 'ASC';
			}
			break;
		case "date":
			$sortname = 'Date';
			if ( $sortfield == 'event.startDateTime' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'event.startDateTime DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'event.startDateTime ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'event.startDateTime ASC';
				$sortfield = 'event.startDateTime';
				$sortdirection = 'ASC';
			}
			break;
		case "active":
			$sortname = 'Active';
			if ( $sortfield == 'event.activeQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'event.activeQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'event.activeQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'event.activeQ ASC';
				$sortfield = 'event.activeQ';
				$sortdirection = 'ASC';
			}
			break;
		case "hide":
			$sortname = 'Hide';
			if ( $sortfield == 'event.hideQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'event.hideQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'event.hideQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'event.hideQ ASC';
				$sortfield = 'event.hideQ';
				$sortdirection = 'ASC';
			}
			break;
		case "public":
			$sortname = 'Public';
			if ( $sortfield == 'track_publicQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'track_publicQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'track_publicQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'track_publicQ ASC';
				$sortfield = 'track_publicQ';
				$sortdirection = 'ASC';
			}
			break;
		default:
			if ( $sortfield != '' )
			{
				$sortby = implode(' ', array($sortfield, $sortdirection));
			} else {
				$sortname = 'Name';
				$sortfield = 'event.name';
				$sortdirection = 'ASC';
				$sortby = 'event.name ASC';
			}
	}

	// insert new sort values into array
	$currentsorts['events']['field'] = $sortfield;
	$currentsorts['events']['direction'] = $sortdirection;
	$currentsorts['events']['name'] = $sortname;

	// save sorts in cookie
	set_sort_cookie($currentsorts);

	return array('name' => $sortname, 'direction' => $sortdirection, 'sortby' => $sortby);
}

/**
 * Figure out the way to sort the participants grid
 *
 * @access  public
 * @params  string  $sortby  Name of the field to sort by
 * @return  array   array of sort information
 */
function get_participants_sort($sortby = '')
{
	// initialize variables
	$sortfield = '';
	$sortdirection = '';
	$sortname = '';

	// get currentsorts from cookie
	if ( FALSE !== ($currentsorts = get_cookie('cc_sort')) )
	{
		$currentsorts = unserialize($currentsorts);
		if ( isset($currentsorts['participants']) )
		{
			$sortfield = $currentsorts['participants']['field'];			// sql field name from model
			$sortdirection = $currentsorts['participants']['direction'];	// direction to sort
			$sortname = $currentsorts['participants']['name'];				// User name for field
		}
	}

	// determine how to sort the grid
	// sortname MUST match the sort_url names in the controller
	switch ($sortby) {
		case "name":
			$sortname = 'Name';
			if ( $sortfield == 'name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'name ASC';
				$sortfield = 'name';
				$sortdirection = 'ASC';
			}
			break;
		case "sortedname":
			$sortname = 'SortedName';
			if ( $sortfield == 'sortedName' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'sortedName DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'sortedName ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'sortedName ASC';
				$sortfield = 'sortedName';
				$sortdirection = 'ASC';
			}
			break;
		case "equipment":
			$sortname = 'Equipment';
			if ( $sortfield == 'equipmentQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'equipmentQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'equipmentQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'equipmentQ ASC';
				$sortfield = 'equipmentQ';
				$sortdirection = 'ASC';
			}
			break;
		case "active":
			$sortname = 'Active';
			if ( $sortfield == 'activeQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'activeQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'activeQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'activeQ ASC';
				$sortfield = 'activeQ';
				$sortdirection = 'ASC';
			}
			break;
		case "hide":
			$sortname = 'Fake';
			if ( $sortfield == 'hideQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'hideQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'hideQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'hideQ ASC';
				$sortfield = 'hideQ';
				$sortdirection = 'ASC';
			}
			break;
		default:
			if ( $sortfield != '' )
			{
				$sortby = implode(' ', array($sortfield, $sortdirection));
			} else {
				$sortname = 'SortedName';
				$sortfield = 'sortedName';
				$sortdirection = 'ASC';
				$sortby = 'sortedName ASC';
			}
	}

	// insert new sort values into array
	$currentsorts['participants']['field'] = $sortfield;
	$currentsorts['participants']['direction'] = $sortdirection;
	$currentsorts['participants']['name'] = $sortname;

	// save sorts in cookie
	set_sort_cookie($currentsorts);

	return array('name' => $sortname, 'direction' => $sortdirection, 'sortby' => $sortby);
}

/**
 * Figure out the way to sort the eventLocations grid
 *
 * @access  public
 * @params  string  $sortby  Name of the field to sort by
 * @return  array   array of sort information
 */
function get_eventlocations_sort($sortby = '')
{
	// initialize variables
	$sortfield = '';
	$sortdirection = '';
	$sortname = '';

	// get currentsorts from cookie
	if ( FALSE !== ($currentsorts = get_cookie('cc_sort')) )
	{
		$currentsorts = unserialize($currentsorts);
		if ( isset($currentsorts['eventlocations']) )
		{
			$sortfield = $currentsorts['eventlocations']['field'];			// sql field name from model
			$sortdirection = $currentsorts['eventlocations']['direction'];	// direction to sort
			$sortname = $currentsorts['eventlocations']['name'];			// User name for field
		}
	}

	// determine how to sort the grid
	// sortname MUST match the sort_url names in the controller
	switch ($sortby) {
		case "eventname":
			$sortname = 'EventName';
			if ( $sortfield == 'event_name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'event_name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'event_name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'event_name ASC';
				$sortfield = 'event_name';
				$sortdirection = 'ASC';
			}
			break;
		case "locationname":
			$sortname = 'LocationName';
			if ( $sortfield == 'location_name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'location_name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'location_name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'location_name ASC';
				$sortfield = 'location_name';
				$sortdirection = 'ASC';
			}
			break;
		default:
			if ( $sortfield != '' )
			{
				$sortby = implode(' ', array($sortfield, $sortdirection));
			} else {
				$sortname = 'EventName';
				$sortfield = 'event_name';
				$sortdirection = 'ASC';
				$sortby = 'event_name ASC';
			}
	}

	// insert new sort values into array
	$currentsorts['eventlocations']['field'] = $sortfield;
	$currentsorts['eventlocations']['direction'] = $sortdirection;
	$currentsorts['eventlocations']['name'] = $sortname;

	// save sorts in cookie
	set_sort_cookie($currentsorts);

	return array('name' => $sortname, 'direction' => $sortdirection, 'sortby' => $sortby);
}

/**
 * Figure out the way to sort the eventParticipants grid
 *
 * @access  public
 * @params  string  $sortby  Name of the field to sort by
 * @return  array   array of sort information
 */
function get_eventparticipants_sort($sortby = '')
{
	// initialize variables
	$sortfield = '';
	$sortdirection = '';
	$sortname = '';

	// get currentsorts from cookie
	if ( FALSE !== ($currentsorts = get_cookie('cc_sort')) )
	{
		$currentsorts = unserialize($currentsorts);
		if ( isset($currentsorts['eventparticipants']) )
		{
			$sortfield = $currentsorts['eventparticipants']['field'];			// sql field name from model
			$sortdirection = $currentsorts['eventparticipants']['direction'];	// direction to sort
			$sortname = $currentsorts['eventparticipants']['name'];				// User name for field
		}
	}

	// determine how to sort the grid
	// sortname MUST match the sort_url names in the controller
	switch ($sortby) {
		case "eventname":
			$sortname = 'EventName';
			if ( $sortfield == 'event_name' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'event_name DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'event_name ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'event_name ASC';
				$sortfield = 'event_name';
				$sortdirection = 'ASC';
			}
			break;
		case "participantname":
			$sortname = 'ParticipantName';
			if ( $sortfield == 'participant_sortedname' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'participant_sortedname DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'participant_sortedname ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'participant_sortedname ASC';
				$sortfield = 'participant_sortedname';
				$sortdirection = 'ASC';
			}
			break;
		case "moderator":
			$sortname = 'Moderator';
			if ( $sortfield == 'moderatorQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'moderatorQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'moderatorQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'moderatorQ ASC';
				$sortfield = 'moderatorQ';
				$sortdirection = 'ASC';
			}
			break;
		case "required":
			$sortname = 'Required';
			if ( $sortfield == 'requiredQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'requiredQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'requiredQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'requiredQ ASC';
				$sortfield = 'requiredQ';
				$sortdirection = 'ASC';
			}
			break;
		case "confirmed":
			$sortname = 'Confirmed';
			if ( $sortfield == 'confirmedQ' )
			{
				if ( $sortdirection == 'ASC' )
				{
					$sortby = 'confirmedQ DESC';
					$sortdirection = 'DESC';
				} else {
					$sortby = 'confirmedQ ASC';
					$sortdirection = 'ASC';
				}
			} else {
				$sortby = 'confirmedQ ASC';
				$sortfield = 'confirmedQ';
				$sortdirection = 'ASC';
			}
			break;
		default:
			if ( $sortfield != '' )
			{
				$sortby = implode(' ', array($sortfield, $sortdirection));
			} else {
				$sortname = 'EventName';
				$sortfield = 'event_name';
				$sortdirection = 'ASC';
				$sortby = 'event_name ASC';
			}
	}

	// insert new sort values into array
	$currentsorts['eventparticipants']['field'] = $sortfield;
	$currentsorts['eventparticipants']['direction'] = $sortdirection;
	$currentsorts['eventparticipants']['name'] = $sortname;

	// save sorts in cookie
	set_sort_cookie($currentsorts);

	return array('name' => $sortname, 'direction' => $sortdirection, 'sortby' => $sortby);
}





/* End of file ConCentric_helper.php */
/* Location: ./system/application/helpers/ConCentric_helper.php */