<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : Grid.php
 *
 * DESCRIPTION   : grid library
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-11 13:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		Grid library Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

// ---------------------------------------------------------------------------

class Grid
{
	function Grid()
	{
		// Get CI Instance
		$this->CI = &get_instance();
	}

	function build_location_grid()
	{
		$this->CI->load->helper('grid');  //load the helper

		// Need to create a list of locations for grid
		$this->CI->load->model('locations_model');    // Instantiate the model
		$query = $this->CI->locations_model->fetch('locations', 'id, sortOrder', '', '', 'sortOrder ASC');  //get data
		foreach ($query->result_array() as $row)
		{
			$locations[$row['sortOrder']] = $row['id'];
		}

		// Build an empty location grid
		$locationGrid = build_empty_grid($this->CI->ccsettings->item('start_date_time'),
										$this->CI->ccsettings->item('end_date_time'),
										$this->CI->ccsettings->item('interval_length'),
										$locations);

		// Select all events with a startdatetime and a location assignment
		$this->CI->load->model('eventlocations_model');
		$query = $this->CI->eventlocations_model->fetchScheduledEvents();

		//loop thru events and add to grid
		foreach ($query->result_array() as $row)
		{
			$id = $row['id'];  //event id
			$locationsort = array($row['sortOrder'] => 1);  //location sortOrder
			$sdttm = strtotime($row['startDateTime']);
			$edttm = strtotime("+".$row['eventLength'].' hour', $sdttm);
			$setup = strtotime("-".$row['setupTime'].' hour', $sdttm);
			$teardown = strtotime("+".$row['teardownTime'].' hour', $sdttm);
			$eventInfo = array('id' => $id,
							'locationsort' => $locationsort,
							'sdttm' => date('Y-m-d H:i:s',$sdttm),
							'edttm' => date('Y-m-d H:i:s',$edttm),
							'setupdttm' => date('Y-m-d H:i:s',$setup),
							'teardowndttm' => date('Y-m-d H:i:s',$teardown),
							'setup' => $row['setupTime'],
							'teardown' => $row['teardownTime'],
							'eventlength' => $row['eventLength']
							);
			
			$locationGrid = assign_event_to_grid($locationGrid, $locationsort, $eventInfo, $this->ccsettings->item('interval_length'));
		}
		print_r($locationGrid);
		return $locationGrid;
	}

}




/* End of file Panels.php */
/* Location: ./system/application/libraries/Panels.php */