<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : departments_model.php
 *
 * DESCRIPTION   : departments model
 *
 * MODIFICATION HISTORY
 *   V1.0   2010-01-12 12:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		departments model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2010
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Departments_model extends base_model
{

	// -------------------------------------------------------------------------
	function Departments_model()
	{
		parent::Base_model();

		// Include all tables that are linked to from departments
		$this->_TABLES = array(
				'departments' => $this->config->item('concentric_table_prefix') . 'departments',
				'locations' => $this->config->item('concentric_table_prefix') . 'locations'
				);

		// Cache to store already fetched items
		$this->_CACHE = array();
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch departments.
	 */
	function fetchDepartments($where = '', $orderby = 'department.name ASC')
	{
		// Build a query to get the data
		$this->db->select('department.id, department.name, location.id AS location_id, location.name AS location_name');
		$this->db->from($this->_TABLES['departments'] . ' department');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = department.locationID', 'left');
		if ($orderby)
			$this->db->order_by($orderby);
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}


}



/* End of file departments_model.php */
/* Location: ./system/application/models/departments_model.php */
