<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : eventparticipants_model.php
 *
 * DESCRIPTION   : eventparticipants model
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-13 12:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		eventparticipants model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Eventparticipants_model extends base_model
{

	// -------------------------------------------------------------------------
	function Eventparticipants_model()
	{
		parent::Base_model();

		// Include all tables that are linked to from events
		$this->_TABLES = array(
				'eventParticipants' => $this->config->item('concentric_table_prefix') . 'eventParticipants',
				'events' => $this->config->item('concentric_table_prefix') . 'events',
				'participants' => $this->config->item('concentric_table_prefix') . 'participants'
				);

		// Cache to store already fetched items
		$this->_CACHE = array();
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch events that have a participant assigned.
	 */
	function fetchEventParticipants($where = '', $orderby = 'event.name ASC, participant.sortedName ASC')
	{
		// Build a query to get the data
		$this->db->select('eventparticipant.id, eventparticipant.moderatorQ, eventparticipant.requiredQ, eventparticipant.confirmedQ, event.id AS event_id, event.name AS event_name, participant.id AS participant_id, participant.name AS participant_name, participant.sortedName AS participant_sortedname, participant.equipmentQ');
		$this->db->from($this->_TABLES['eventParticipants'] . ' eventparticipant');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventparticipant.eventID', 'left');
		$this->db->join($this->_TABLES['participants'] . ' participant', 'participant.id = eventparticipant.participantID', 'left');
		if ($orderby)
			$this->db->order_by($orderby);
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch active event(s) with a startDateTime and which has an active participant assigned
	 */
	function fetchScheduledEvents($where = '', $orderby = '')
	{
		$this->db->select('distinct event.id, participant.sortedName, event.startDateTime, event.eventLength, event.setupTime, event.teardownTime');
		$this->db->from($this->_TABLES['eventParticipants'] . ' eventparticipant');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventparticipant.eventID', 'left');
		$this->db->join($this->_TABLES['participants'] . ' participant', 'participant.id = eventparticipant.participantID', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('participant.activeQ = 1');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		if ($orderby)
			$this->db->order_by($orderby);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

	// -------------------------------------------------------------------------
	/**
	* Convert the query object to a array of participant strings using event id as key
	*/
	function convertParticipantsToStr($where = '', $orderby = 'event.name ASC, participant.sortedName ASC', $mode = 'internal')
	{
		$rows = $this->fetchEventParticipants($where, $orderby);
		if ($rows->num_rows() == 0)
		{
			return '';
		}

		$data = array();
		//loop thru query results and build array
		foreach ($rows->result_array() as $row)
		{
			$mod = ($row['moderatorQ'] == 1) ? ' (M)' : '';
			$req = ($row['requiredQ'] == 1) ? ' (R)' : '';
			$conf = ($row['confirmedQ'] == 1) ? ' (C)' : '';
			if ($mode == 'internal')
			{
				$data[$row['event_id']][] = $row['participant_name'] . $mod . $req . $conf;
			} else {
				$data[$row['event_id']][] = $row['participant_name'] . $mod;
			}
		}
		//flashMsg('info','<pre>'.print_r($data, TRUE).'</pre>');
		//loop thru array and change values to strings
		foreach ($data as $key => $value)
		{
			$returndata[$key] = implode(', ', $value);
		}
		//flashMsg('info','<pre>'.print_r($returndata, TRUE).'</pre>');
		return $returndata;
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch DISTINCT participants assigned to active, scheduled events.
	 *   Default is to not show equipment.
	 */
	function fetchScheduledParticipants($where = 'participant.equipmentQ = 0', $orderby = 'participant.sortedName ASC')
	{
		// Build a query to get the data
		$this->db->select('distinct participant.id, participant.sortedName, participant.name, participant.email, participant.phoneNumber');
		$this->db->from($this->_TABLES['eventParticipants'] . ' eventparticipant');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventparticipant.eventID', 'left');
		$this->db->join($this->_TABLES['participants'] . ' participant', 'participant.id = eventparticipant.participantID', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('participant.activeQ = 1');
		$this->db->where('participant.hideQ = 0');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		if ($orderby)
			$this->db->order_by($orderby);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch participants assigned to active, scheduled events.
	 *   Default is to not show equipment.
	 */
	function fetchScheduledParticipants2($where = 'participant.equipmentQ = 0', $orderby = 'participant.sortedName ASC')
	{
		// Build a query to get the data
		$this->db->select('participant.id, participant.sortedName, participant.name, participant.email, participant.phoneNumber, eventparticipant.moderatorQ');
		$this->db->from($this->_TABLES['eventParticipants'] . ' eventparticipant');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventparticipant.eventID', 'left');
		$this->db->join($this->_TABLES['participants'] . ' participant', 'participant.id = eventparticipant.participantID', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('participant.activeQ = 1');
		$this->db->where('participant.hideQ = 0');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		if ($orderby)
			$this->db->order_by($orderby);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

}



/* End of file eventparticipants_model.php */
/* Location: ./system/application/models/eventparticipants_model.php */
