<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : participants_model.php
 *
 * DESCRIPTION   : participants model
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		Participants model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */


class Participants_model extends base_model
{

	function Participants_model()
	{
		parent::Base_model();

		$this->_TABLES = array('participants' => $this->config->item('concentric_table_prefix') . 'participants');

		// Cache to store already fetched items
		$this->_CACHE = array();

	}

	/**
	 * Get the next record using sortedName
	 *
	 * @access public
	 * @params string oldNm old sorted name
	 */
	function getNextBySortedName($oldNm = '')
	{
		$this->db->select('id, sortedName');
		$this->db->from($this->_TABLES['participants']);
		$this->db->where('sortedName > "' . $oldNm . '"');
		$this->db->order_by('sortedName','ASC');
		$this->db->limit(1);
		$query = $this->db->get();

		$nextId = 0;
		if ($query->num_rows() > 0)
		{
			$row = $query->row_array();
			$nextId = $row['id'];
		}

		return $nextId;
	}

}


/* End of file participants_model.php */
/* Location: ./system/application/models/participants_model.php */